#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

from main.container import Controller
from main.basedlgview import BaseDlgView
from models.kbmodel import KeyBoardModel
from common.carlog import DEBUG

class LoadingController(Controller):

    def __init__(self, cb):
        self.cb = callable(cb) and cb or None
        self.view = BaseDlgView("loading", layer=30)
        self.view.signal_callback_add("hide", "", self.__destroy)
        self.view.signal_callback_add("button-back-pressed", "",
            self.__cancel_loading)

        self.kb_model = KeyBoardModel()
        self.kb_model.add_key_down_cb(self.__key_down_cb)

    def __del__(self):
        DEBUG("deleting Loading Controller %s" % self)

    def __key_down_cb(self, obj, event):
        if event.key == "Escape":
            self.view.hide()
            self.__cancel_loading()
            return True

        return False

    def __destroy(self, *data):
        self.cb = None
        self.kb_model.del_key_down_cb(self.__key_down_cb)

    def __cancel_loading(self, *params):
        if self.cb:
            self.cb()

    def show(self):
        self.view.show()

    def hide(self):
        self.view.hide()
