#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#


from common.carlog import DEBUG
from pairingdlgview import PairingDlgView
from models.btmodel import BtModel
from models.kbmodel import KeyBoardModel

class PairingDlgController(object):

    def __init__(self):
        self.view = None
        self.address = None
        self.display_value = ""
        self.visible = False
        self.kb_model = KeyBoardModel()

    def __del__(self):
        DEBUG("deleting pairing view %s" % self)

    def hide(self):
        if self.visible:
            self.cancel_cb()

    def show(self, address):
        self.visible = True
        self.address = address
        self.view = PairingDlgView()
        self.view.display_set(self.display_value)
        cbs = (self.key_0_cb,
                self.key_1_cb,
                self.key_2_cb,
                self.key_3_cb,
                self.key_4_cb,
                self.key_5_cb,
                self.key_6_cb,
                self.key_7_cb,
                self.key_8_cb,
                self.key_9_cb)

        self.view.keyboard_connect_cbs(cbs)
        self.view.clear_connect_cb(self.clear_cb)
        self.view.confirm_connect_cb(self.confirm_cb)
        self.view.cancel_connect_cb(self.cancel_cb)
        self.view.signal_callback_add("hide", "", self.__destroy)
        self.view.show()
        self.kb_model.add_key_down_cb(self.__key_down_cb)

    def __key_down_cb(self, obj, event):
        if event.key == "Escape":
            self.cancel_cb()
        elif event.key >= "0" and event.key <= "9":
            self.add_display_value(event.key)
        elif event.key == "BackSpace":
            self.clear_cb()
        else:
            return False

        return True

    def __destroy(self, *data):
        self.kb_model.del_key_down_cb(self.__key_down_cb)

    def confirm_cb(self, *data):
        self.view.hide()
        BtModel().passkey_success(self.address, self.display_value)

    def cancel_cb(self, *data):
        self.view.hide()
        BtModel().passkey_success(self.address, "")

    def clear_cb(self, *data):
        self.display_value = self.display_value[:-1]
        self.view.display_set(self.display_value)

    def add_display_value(self, value):
        if len(self.display_value) < 6:
            self.display_value = self.display_value + value
            self.view.display_set(self.display_value)

    def key_0_cb(self, *data):
        self.add_display_value("0")

    def key_1_cb(self, *data):
        self.add_display_value("1")

    def key_2_cb(self, *data):
        self.add_display_value("2")

    def key_3_cb(self, *data):
        self.add_display_value("3")

    def key_4_cb(self, *data):
        self.add_display_value("4")

    def key_5_cb(self, *data):
        self.add_display_value("5")

    def key_6_cb(self, *data):
        self.add_display_value("6")

    def key_7_cb(self, *data):
        self.add_display_value("7")

    def key_8_cb(self, *data):
        self.add_display_value("8")

    def key_9_cb(self, *data):
        self.add_display_value("9")
