#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""
Implements L{PointerEvent}.

@todo: Document this module.
"""

import evas, edje

class PointerEvent(evas.SmartObject):
    """
    @todo: Document this class.
    """
    def __init__(self, canvas, controller):
        evas.SmartObject.__init__(self, canvas)
        self.dragged = False
        self.button_down = False
        self.activated = False
        self.controller = controller
        self.pointer = self.Image()
        self.pointer.alpha_set(True)
        self.guide = self.Rectangle()
        self.area = self.Rectangle(color=(0, 0, 0, 0))
        self.area.on_mouse_move_add(self.__on_mouse_move)
        self.area.on_mouse_down_add(self.__on_mouse_down)
        self.area.on_mouse_up_add(self.__on_mouse_up)

    def __on_mouse_move(self, obj, event):
        if self.button_down:
            x = event.position.output.x
            if self.pos[0] < x < self.pos[0] + self.w:
                self.move_point(x)

    def __on_mouse_down(self, obj, event):
        if self.activated:
            self.button_down = True

    def __on_mouse_up(self, obj, event):
        if self.button_down:
            self.button_down = False
            self.set_point(self.pointer.center[0])

    def set_point(self, x):
        frac = float(x - self.pos[0]) / self.area.size[0]
        self.controller.selected_point(frac)

    def move_point(self, x):
        self.pointer.move(x - self.pointer.size[0] / 2, self.pointer.pos[1])
        self.guide.move(self.pointer.center[0], self.pointer.pos[1]-self.guide.size[1])

    def resize(self, w, h):
        self.w = w
        self.h = h
        self.area.resize(w, h)

    def set_view(self, theme, view):
        self.pointer.file_set(theme, "images/trip-pin-holder")
        color = edje.file_data_get(theme, "trips:selector-color")
        r, g, b, a = [(int(x)) for x in color.split(":")]
        self.guide.color_set(r, g, b, a)
        size = edje.file_data_get(theme, "trips:selector-size")
        w, h = [(int(x)) for x in size.split(":")]
        self.guide.size_set(w, h)
        w, h = self.pointer.image_size_get()
        self.pointer.size_set(w, h)
        self.pointer.fill_set(0, 0, w, h)
        view.part_swallow("pointer_event", self)

    def clip_set(self, obj):
        self.area.clip_set(obj)
        self.pointer.clip_set(obj)
        self.guide.clip_set(obj)

    def clip_unset(self):
        self.area.clip_unset()
        self.pointer.clip_unset()
        self.guide.clip_unset()

    def activate(self):
        self.set_point(self.pos[0])
        self.move_point(self.pos[0])
        self.guide.show()
        self.pointer.show()
        self.activated = True

    def deactivate(self):
        self.pointer.hide()
        self.guide.hide()
        self.activated = False

    def show(self):
        self.area.show()

    def hide(self):
        self.area.hide()
