#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import os, gdbm, ConfigParser

from distutils.core import setup, Extension
from distutils.dist import Distribution
from distutils.cmd import Command
from distutils.command.build import build
from distutils.dep_util import newer
from subprocess import Popen, PIPE

CFLAGS = Popen(['pkg-config', '--cflags', 'evas'], \
    stdout=PIPE).communicate()[0].split()
LDFLAGS = Popen(['pkg-config', '--libs', 'evas'], \
    stdout=PIPE).communicate()[0].split()

def dtc_db_filename(full_name):
    filename = os.path.basename(full_name)
    return os.path.splitext(filename)[0] + '.db'

class carman_dist(Distribution):

    def __init__(self, attrs=None):
        self.dtc_files = None
        Distribution.__init__(self, attrs)

    def has_dtc_files (self):
        return self.dtc_files and len(self.dtc_files) > 0

class carman_build(build):

    def has_dtcs(self):
        return self.distribution.has_dtc_files()

    build.sub_commands.append(('build_dtcs', has_dtcs))

class build_dtcs(Command):

    description = "\"build\" dtc gdbm database (copy to build directory)"

    user_options = [
        ('build-base=', 'd', "directory to \"build\" (copy) to"),
        ('force', 'f', "forcibly build everything (ignore file timestamps"),
        ]

    boolean_options = ['force']

    def initialize_options (self):
        self.dtc_files = None
        self.force = None
        self.build_base = None
        self.build_dtcs = None

    def finalize_options (self):
        self.set_undefined_options('build',
                                  ('force', 'force'),
                                  ('build_base','build_base'))
        self.dtc_files = self.distribution.dtc_files
        self.build_dtcs = os.path.join(self.build_base, 'dtcs')

    def run (self):
        if not self.dtc_files:
            return
        print "building dtc"
        self.build_dtcs_db()

    def build_dtcs_db(self):

        def create_dtc_db(infile, outfile):
            cfg = ConfigParser.ConfigParser()
            cfg.optionxform = str
            cfg.read([infile, ])

            dir = os.path.dirname(outfile)
            self.mkpath(dir)

            db = gdbm.open(outfile, 'n')

            for key in cfg.options('dtcs') :
                db[key] = cfg.get('dtcs', key)

            db.sync()
            db.close()

        for in_file, inst_dest in self.dtc_files:
            builtfile = os.path.join(self.build_dtcs, dtc_db_filename(in_file))
            if not self.force and not newer(in_file, builtfile):
                self.announce("not building %s (up-to-date)" % in_file)
                continue
            create_dtc_db(in_file, builtfile)

setup( \
    name='carman-evas', \
    version='0.7', \
    description='carman rich view package', \
    long_description='carman rich view (EVAS based) package', \
    url='http://www.openbossa.indt.org/carman', \
    scripts=['carman-evas'], \
    packages=['main', 'models', 'gauges', 'maps', 'trips', 'plugins', \
        'themes.modules', 'models.plugins', 'options','common', \
        'common.dbus_bt'], \
    ext_modules=[
        Extension(name='main.evasutil', \
            sources=['main/evasutil.c'], libraries=['evas'], \
            extra_compile_args=CFLAGS, extra_link_args=LDFLAGS), \
        Extension(name='main.trip', \
            sources=['main/trip.c'], extra_compile_args=CFLAGS, \
            extra_link_args=LDFLAGS)], \
    dtc_files = [('data/dtcs.in', 'share/carman')], \
    distclass = carman_dist, \
    cmdclass = {'build_dtcs': build_dtcs}
)
