#  osmrepo.py - Open Street Maps repository
#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""
Implements L{OSMRepo}.
"""

from models.reposet import RepoBase

class OSMRepo(RepoBase):
    """
    OpenStreet maps repository.

    @ivar   NAME: Repository name.
    @ivar   CACHE_NAME: Repository directory name.
    @ivar   URI: Repository internet address format.
    """
    NAME = "Open Street"
    CACHE_NAME = ".osmcache"
    URI = "http://tile.openstreetmap.org/%d/%d/%d.png"

    def build_uri(self, tile_x, tile_y, zoom):
        """
        Builds image tile address.

        @type   tile_x: number
        @param  tile_x: Map tile M{X} coordinate.
        @type   tile_y: number
        @param  tile_y: Map tile M{Y} coordinate.
        @type   zoom: number
        @param  zoom: Map zoom.
        """
        return self.URI % (self.ZOOM[-1] - zoom, tile_x, tile_y)

def get_repository():
    """
    Returns an instance of L{OSMRepo} class.

    @rtype: class
    @return: Instance of L{OSMRepo} class.
    """
    return OSMRepo()
