#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""
Implements L{LoadingController}.
"""

from main.container import Controller
from main.basedlgview import BaseDlgView
from models.kbmodel import KeyBoardModel

class LoadingController(Controller):
    """
    Loading Controller dialog class.

    @deprecated: This class is not being used due to the bugs
                 related to the DownloadTrackController class.

    @type   cb: callback
    @param  cb: Cancel Loading callback.
    """
    def __init__(self, cb):
        self.cb = callable(cb) and cb or None
        self.view = BaseDlgView("loading", layer=30)
        self.view.signal_callback_add("hide", "", self.__destroy)
        self.view.signal_callback_add("button-back-pressed", "",
            self.__cancel_loading)

        self.kb_model = KeyBoardModel()
        self.kb_model.add_key_down_cb(self.__key_down_cb)

    def __key_down_cb(self, obj, event):
        """
        Called when mouse button is pressed over the L{etk.Entry} object.

        @type   obj: L{etk.Entry}
        @param  obj: etk entry object.
        @type   event: EventMouseDown
        @param  event: Event mouse down object.
        """
        if event.key == "Escape":
            self.view.hide()
            self.__cancel_loading()
            return True

        return False

    def __destroy(self, *data):
        """
        Called when the dialog is closed.

        @type   data: object
        @param  data: Not used.
        """
        self.cb = None
        self.kb_model.del_key_down_cb(self.__key_down_cb)

    def __cancel_loading(self, *params):
        """
        Called when the loading process is cancelled.

        @type   params: object
        @param  params: Not used.
        """
        if self.cb:
            self.cb()

    def show(self):
        """
        Displays the L{BaseDlgView} object.
        """
        self.view.show()

    def hide(self):
        """
        Hides the dialog.
        """
        self.view.hide()

