#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""
Implements L{DeleteAccountController}.
"""

from main.messagedlgctrl import MessageDlgController
from models.infosharingmodel import InfoSharingModel


class DeleteAccountController(object):
    """
    Deletes an InfoShare account.

    @type   parent: L{ManageAccounts}.
    @param  parent: Parent window.
    """

    def __init__(self, parent):
        self._parent = parent
        self.is_service = InfoSharingModel().service

    def exist_account(self):
        """
        Verifies if InfoShare account exists.

        @rtype: boolean
        @return: C{True} if InfoShare account exists, C{False} otherwise.
        """
        if self.is_service.get_account():
            return True
        else:
            msg = MessageDlgController()
            msg.show_message("No account saved", title="DELETE ACCOUNT")
            return False

    def delete_account(self):
        """
        Deletes InfoShare account.
        """
        def delete():
            self.is_service.remove_account()
            self._parent.hide(True)
            self._parent._parent.hide(True)

        def disconnect_account():
            self.is_service.account_disconnect()
            delete()

        account = self.is_service.get_account()[0].split("/")[0]
        if self.is_service.account_is_enabled():
            msg = MessageDlgController(confirm_cb=disconnect_account)
            msg.show_message("This account is currently active.<br>" \
                "Disconnect and delete<br>%s?" % account, buttons=2, \
                title="DELETE ACCOUNT")
        else:
            msg = MessageDlgController(confirm_cb=delete)
            msg.show_message("Do you want to delete account <br>%s?" % \
                account, buttons=2, title="DELETE ACCOUNT")
