/*
 *
 *  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
 *
 *  This file is part of infosharingd.
 *
 *  infosharingd is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  infosharingd is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with infosharingd. If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef __SERVER_H__
#define __SERVER_H__

#define INFOSHARING_DIR         "/home/user/MyDocs/Carman/.purple"
#define INFOSHARING_NAME        "infosharingd"
#define INFOSHARING_VERSION     "0.7~beta2-4"
#define INFOSHARING_WEBSITE     "http://openbossa.indt.org/carman"
#define INFOSHARING_DEV_WEBSITE "http://garage.maemo.org/projects/carman"

typedef struct InfoShareAccount {
	PurpleAccount *purple_acc;
	gboolean ready; /* Indicates if an account is fully configured or not */
} InfoShareAccount;

typedef struct PendingRequestAuthorization {
	void (*authorize_cb) (void *user_data);
	void (*deny_cb) (void *user_data);
	void *user_data;
} PendingRequestAuthorization;

GHashTable *convs;
GHashTable *pending_requests;
InfoShareAccount *carman_account;

void infosharingd_finalize(void *user_data);

#endif /* __SERVER_H__ */
