/*
 *
 *  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
 *
 *  This file is part of infosharingd.
 *
 *  infosharingd is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  infosharingd is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with infosharingd. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef INFOSHARINGD_LOGMSG_H
#define INFOSHARINGD_LOGMSG_H

#undef		G_LOG_DOMAIN
#define		G_LOG_DOMAIN	"infosharingd"

//#define DEBUG 1

/* Message API for InfoSharingd Daemon */

#define infosharingd_message(mesg...)	\
	g_message(mesg)

#define infosharingd_warning(mesg...)	\
	g_warning(mesg)

/* fatal at runtime
 * by setting the G_DEBUG environment variable. */
/* g_error(mesg) - result in a core dump;
 * don't use it for errors you expect. */
#define infosharingd_error(mesg...)	\
	g_warning(mesg)

#ifdef DEBUG

#define infosharingd_debug(mesg...)	\
	g_debug(mesg)

#else

#define infosharingd_debug(mesg...)

#endif

#define infosharingd_vdebug infosharingd_debug

#endif /* INFOSHARINGD_LOGMSG_H */
