/*
** BOMBERMAN
**
** Bomberman Launcher - Used to start Bomberman on the Nokia 770-810 with Maemo 2
**
** (c) 2007 by Klaus Rotter.
**
** It may be distributed under the terms of the GNU Public Licence Version 2
**
** HISTORY:
**
** 2007-01-09: Started - Based on helloworld.c 0.4
*/

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <signal.h>

// To get IP Adress

#include <sys/socket.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include <net/if.h>
#include <arpa/inet.h>

// For Maemo/Osso/GTK Programming

#include <gtk/gtk.h>
#include <libosso.h>

// include XPM pixmaps

#include <bmlogo.xpm>
#include <bmtitel.xpm>

// Prototypes

GtkWindow *bomberman_new (void);
void bomberman_dialog_show (void);

// Global variables

GtkWidget *window, *rbnOwnSrv, *rbnConnectSrv, *etyServer, *etyNick, *cbxPlayer;
GtkWidget *ckbSound, *ckbSwapKeys;

// Prefs

int own_prefs=1;	// Start own server
int snd_prefs=1;	// Enable sound
int key_prefs=1;	// Swap Keys, right side Exit % drop bomb
int plr_prefs=2;	// Start 3 computer enemies
char nick_prefs[80] = ""; // No nick
char srv_prefs[80] = "";  // No server address

// Get IP Adress of local device- for Nokia 770-810 its "wlan0"

char retstr[50];

// There are some problems with the ifreq struct. If I compile the seconde get_ip_addr func,
// I get the error 
// bomberman.c: In function get_ip_addr':
// bomberman.c:74: error: storage size of 'ifa' isn't known
// So I use the first one, which is a hack but it works... Idea: ifreq is 32 bytes long and has
// two unions, each 16 bytes long. So I do it on my own.

#ifdef __ARMEL__
char *get_ip_addr (void)
{
    char ifa[32];		// was "struct ifreq ifa;"
    struct sockaddr_in *i;
    int fd;

    strcpy (retstr, "not available. Start WLAN?");

    strcpy (ifa, "wlan0");	// For Nokia 770-810, use wlan0

    if ((fd = socket (AF_INET, SOCK_DGRAM, 0)) == -1)
	return (retstr);	// Error: return "error: not available"

    if (ioctl (fd, SIOCGIFADDR, (struct ifreq *) ifa))
	return (retstr);	// Error: return "error: not available"

    i = (struct sockaddr_in *) &ifa[16];

    strncpy (retstr, inet_ntoa (i->sin_addr),50);
    retstr[49]=0;
    close (fd);

    return (retstr);
}
#else
char *get_ip_addr (void)
{
    struct ifreq ifa;
    struct sockaddr_in *i;
    int fd;

    strcpy (retstr, "not available. Start WLAN?");

    strcpy (ifa.ifr_name, "eth1");	// For Nokia 770-810, use wlan0

    if ((fd = socket (AF_INET, SOCK_DGRAM, 0)) == -1)
	return (retstr);	// Error: return "error: not available"

    if (ioctl (fd, SIOCGIFADDR, &ifa))
	return (retstr);	// Error: return "error: not available"

    i = (struct sockaddr_in *) &ifa.ifr_addr;
    strcpy (retstr, inet_ntoa (i->sin_addr));
    close (fd);

    return (retstr);
}
#endif

static void window_destroy (GtkWidget * widget, gpointer data)
{
    gtk_main_quit ();
}


static void start_bm (GtkButton * button, gpointer data)
{
    char buffer[250];
    char snd[4];
    char swp[4];
    pid_t pid;

    snd[0] = 0;
    swp[0] = 0;

    if (!gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (ckbSound)))
	strcpy (snd, "-q");

	// Swap softkeys
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (ckbSwapKeys)))
	strcpy (swp, "-w");

    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (rbnOwnSrv)))
	{
	    // Button "OwnServer" is selected
	    // Start Server

	    pid = fork ();	// Lets start second thread

	    if (pid == -1)
		{		// Error, could not start thread
		    printf ("Could not start server thread");
		}
	    else if (pid == 0)	// child thread
		{		// New bombermanserver threat
		    get_ip_addr();
		    if (strcmp(retstr,"not available. Start WLAN?") == 0)
		      sprintf (buffer, "bombermanserver");
		    else
		      sprintf (buffer, "bombermanserver -h %s",retstr);      
		    puts (buffer);
		    system (buffer);
		    exit (0);
		}
	    else
		{		// main thread
		    printf ("Child thread's pid %d\n", pid);

		    get_ip_addr();
		    if (strcmp(retstr,"not available. Start WLAN?") == 0)
                        sprintf (buffer, "bombermanclient -b %d %s %s",
			     gtk_combo_box_get_active (GTK_COMBO_BOX (cbxPlayer)), swp, snd);
		    else
                        sprintf (buffer, "bombermanclient -h %s -b %d %s %s", retstr,
			     gtk_combo_box_get_active (GTK_COMBO_BOX (cbxPlayer)), swp, snd);
		    puts (buffer);
		    system (buffer);
		    int i;
		    for (i = 0; i < 6; i++)
			kill (pid + i, 15);	// Send TERMINATE to bombermanserver                                                  
		}
	}
    else
	{
	    // Button "Connect to another Server" is selected
	    if (strcmp ("", (char *) gtk_entry_get_text (GTK_ENTRY (etyServer))) == 0)	// Test if there's a server name present 
		{
		    GtkWidget *dialog = gtk_message_dialog_new (GTK_WINDOW (window),
								GTK_DIALOG_DESTROY_WITH_PARENT,
								GTK_MESSAGE_ERROR,
								GTK_BUTTONS_CLOSE,
								"Please specify a valid server address for network games!");
		    gtk_dialog_run (GTK_DIALOG (dialog));
		    gtk_widget_destroy (dialog);
		    return;
		}
	    if (strcmp ("", (char *) gtk_entry_get_text (GTK_ENTRY (etyNick))) == 0)	// Test if there's a nickname present 
		{
		    GtkWidget *dialog = gtk_message_dialog_new (GTK_WINDOW (window),
								GTK_DIALOG_DESTROY_WITH_PARENT,
								GTK_MESSAGE_ERROR,
								GTK_BUTTONS_CLOSE,
								"Please specify a nick name for network games!");
		    gtk_dialog_run (GTK_DIALOG (dialog));
		    gtk_widget_destroy (dialog);
		    return;
		}
	    sprintf (buffer, "bombermanclient -h %s -n %s %s %s",
		     gtk_entry_get_text (GTK_ENTRY (etyServer)),
		     gtk_entry_get_text (GTK_ENTRY (etyNick)), swp, snd);
	    puts (buffer);
	    system (buffer);
	}
}

void savePrefs(void)
{
    FILE *f;
    char buf[40];
    
    strncpy(buf,getenv("HOME"),32);
    strcat(buf,"/.bmrc");
    
    printf("Prefsfile %s\n",buf);
  
    if ((f = fopen(buf,"w")) == NULL)
    {
        printf("Can't open prefs file '%s' for writing!\n",buf);
        return;  
    }	
    fprintf(f,"# Preferences file for bomberman - machine generated, do not edit!\n");

    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (rbnOwnSrv)))
        fprintf(f,"1 # 0=Connect to server 1=Start own server\n");
    else
        fprintf(f,"0 # 0=Connect to server 1=Start own server\n");
             
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (ckbSound)))
        fprintf(f,"1 # 0=Disable Sound 1=Enable Sound\n");
    else
        fprintf(f,"0 # 0=Disable Sound 1=Enable Sound\n");
    
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (ckbSwapKeys)))
        fprintf(f,"1 # 1=Swap softkeys (Exit & Bombs right)\n");
    else
        fprintf(f,"0 # 1=Swap softkeys (Exit & Bombs right)\n");
	
	fprintf(f,"%d # Number of computer enemies\n",gtk_combo_box_get_active (GTK_COMBO_BOX (cbxPlayer)));
    fprintf(f,"%s # Server address\n",gtk_entry_get_text (GTK_ENTRY (etyServer)));
    fprintf(f,"%s # Nick name\n", gtk_entry_get_text (GTK_ENTRY (etyNick)));
    fclose(f);
}

void loadPrefs(void)
{
    FILE *f;
    char buf[80];
    
    strncpy(buf,getenv("HOME"),32);
    strcat(buf,"/.bmrc");
    
    if ((f = fopen(buf,"r")) == NULL)
    {
        printf("Can't open prefs file '%s' for reading!\n",buf);
        return;  
    }

    // Ignore first line '# Preferences file for bomberman - machine...'
	fgets(buf,80,f);

	// OwnSrv
	fgets(buf,80,f);
	if (buf[0] == '0')
	    own_prefs = 0;
    else
        own_prefs = 1;
        
    // Sound
    fgets(buf,80,f);
	if (buf[0] == '0')
	    snd_prefs = 0;
    else
        snd_prefs = 1;

    // Swap keys    
    fgets(buf,80,f);
	if (buf[0] == '0')
	    key_prefs = 0;
    else
        key_prefs = 1;

    // Number of computer enemies   
    fgets(buf,80,f);
    plr_prefs = buf[0]-48;
    if (plr_prefs < 0) plr_prefs = 0;
    else if (plr_prefs > 4) plr_prefs = 4;
    
    fgets(buf,80,f);
    sscanf(buf,"%s",srv_prefs);
    if (srv_prefs[0] == '#') srv_prefs[0] = 0;

    fgets(buf,80,f);
    sscanf(buf,"%s",nick_prefs);
    if (nick_prefs[0] == '#') nick_prefs[0] = 0;    
    //printf("Server %s Nick %s\n",srv_prefs, nick_prefs);

    fclose(f);
}

static void quit_bm (GtkButton * button, gpointer data)
{
    savePrefs();
    gtk_widget_destroy (GTK_WIDGET (data));
}


static void display_help (GtkButton * button, gpointer data)
{
    GtkWidget *dialog = gtk_message_dialog_new_with_markup (GTK_WINDOW (window),
							    GTK_DIALOG_DESTROY_WITH_PARENT,
							    GTK_MESSAGE_INFO,
							    GTK_BUTTONS_OK,
							    "<small><b>Gameplay:\n</b>"
							    "<b>Cursor keys</b> - move around\n"
							    "<b>Select key</b> - drob a bomb\n"
							    "<b>Cancel,Close</b> or <b>Home key</b> - exit game\n\n"
							    "If you want to play alone simply select <i>own server</i> "
							    "and the select the number of computer enemies. If you want that "
							    "other join your game you must give them your 770/8xx's IP address "
							    "and the others select <i>Connect to server</i> and enter the IP address. "
							    "Please start WLAN and enter a nick name!</small>");
    gtk_dialog_run (GTK_DIALOG (dialog));
    gtk_widget_destroy (dialog);
}


GtkWindow *bomberman_new (void)
{
    GtkWidget *label, *btnStart, *btnHelp, *btnQuit, *imgLogo, *imgTitle;
    GtkWidget *fix, *frmPlayer;

    GdkPixbuf *pixLogo, *pixTitle;

    window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

    gtk_container_set_border_width (GTK_CONTAINER (window), 10);

    gtk_window_set_title (GTK_WINDOW (window), "Bomberman");

    g_signal_connect (G_OBJECT (window), "destroy", G_CALLBACK (window_destroy), NULL);

    // We have more or less a fixed window, so using a fixed layout manager will get me rid of
    // those large number ov h- and vboxes.
    fix = gtk_fixed_new ();
    gtk_container_add (GTK_CONTAINER (window), fix);

    // Draw Bomberman picture
    pixLogo = gdk_pixbuf_new_from_xpm_data ((const char **) bmlogo_xpm);
    imgLogo = gtk_image_new_from_pixbuf (pixLogo);
    gtk_fixed_put (GTK_FIXED (fix), imgLogo, 500, 0);

    // Draw Bomberman Title
    pixTitle = gdk_pixbuf_new_from_xpm_data ((const char **) bmtitel_xpm);
    imgTitle = gtk_image_new_from_pixbuf (pixTitle);
    gtk_fixed_put (GTK_FIXED (fix), imgTitle, 25, 0);

    // Info Label
    label = gtk_label_new (NULL);
    gtk_label_set_markup (GTK_LABEL (label),
			  "<small><b>Version " VERSION " compiled " __DATE__ "</b>\n"
			  "(c) 2000-2002 by <b>Robert Hockauf</b>\n"
			  "Nokia N770/N8xx Port and enhancements (c) 2003-08 by <b>Klaus Rotter</b>\n"
			  "<i>It may be distributed under the GNU Public Licence Version 2</i></small>");
    gtk_fixed_put (GTK_FIXED (fix), label, 25, 50);

    // Frame Preferences
    frmPlayer = gtk_frame_new (" Prefs ");
    gtk_fixed_put (GTK_FIXED (fix), frmPlayer, 20, 145);
    gtk_widget_set_size_request (frmPlayer, 640, 170);

    // Radiobutton "Connect to server" with label 
    rbnConnectSrv = gtk_radio_button_new_with_label (NULL, "Connect to server:");
    gtk_fixed_put (GTK_FIXED (fix), rbnConnectSrv, 40, 180);
    etyServer = gtk_entry_new_with_max_length (40);	// Max 40 chars
    gtk_entry_set_text(GTK_ENTRY(etyServer), srv_prefs);
    //gtk_widget_set_size_request (etyServer,640,100);
    gtk_fixed_put (GTK_FIXED (fix), etyServer, 290, 180);

    // Enter Nickname
    gtk_fixed_put (GTK_FIXED (fix), gtk_label_new ("Own nickname:"), 80, 210);
    etyNick = gtk_entry_new_with_max_length (16);	// Max 16 chars
    gtk_fixed_put (GTK_FIXED (fix), etyNick, 290, 210);
    gtk_entry_set_text(GTK_ENTRY(etyNick),nick_prefs);

    // Radiobutton "Own Server"
    char rbuf[100];
    sprintf (rbuf, "Use own server (IP-Addr %s)", get_ip_addr ());
    rbnOwnSrv =
	gtk_radio_button_new_with_label (gtk_radio_button_get_group
					 (GTK_RADIO_BUTTON (rbnConnectSrv)), rbuf);
    gtk_fixed_put (GTK_FIXED (fix), rbnOwnSrv, 40, 250);

    if (own_prefs)
        gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (rbnOwnSrv), TRUE);
    else    
        gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (rbnConnectSrv), TRUE);

    // Number of Players 
    gtk_fixed_put (GTK_FIXED (fix), gtk_label_new ("Number of computer enemies:"), 80, 280);

    cbxPlayer = gtk_combo_box_new_text ();
    gtk_combo_box_append_text (GTK_COMBO_BOX (cbxPlayer), "none");
    gtk_combo_box_append_text (GTK_COMBO_BOX (cbxPlayer), "1");
    gtk_combo_box_append_text (GTK_COMBO_BOX (cbxPlayer), "2");
    gtk_combo_box_append_text (GTK_COMBO_BOX (cbxPlayer), "3");
    gtk_combo_box_append_text (GTK_COMBO_BOX (cbxPlayer), "4");
    gtk_combo_box_set_active (GTK_COMBO_BOX (cbxPlayer), plr_prefs);
    gtk_fixed_put (GTK_FIXED (fix), cbxPlayer, 420, 280);

    // Checkbuttons for Sound and swap softkeys
    ckbSound = gtk_check_button_new_with_label ("Sound");
    gtk_fixed_put (GTK_FIXED (fix), ckbSound, 480, 180);
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (ckbSound), snd_prefs);

    // Swap soft keys?
    ckbSwapKeys = gtk_check_button_new_with_label ("Swap Softkey");
    gtk_fixed_put (GTK_FIXED (fix), ckbSwapKeys, 480, 210);
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (ckbSwapKeys), key_prefs);
    
    // Three Buttons: Start, Info and Quit 
    btnStart = gtk_button_new_with_label ("Start Game");
    gtk_widget_set_size_request (btnStart, 250, 60);
    gtk_fixed_put (GTK_FIXED (fix), btnStart, 20, 330);
    g_signal_connect (G_OBJECT (btnStart), "clicked", G_CALLBACK (start_bm), window);

    btnHelp = gtk_button_new_with_label ("Info");
    gtk_widget_set_size_request (btnHelp, 100, 60);
    gtk_fixed_put (GTK_FIXED (fix), btnHelp, 290, 330);
    g_signal_connect (G_OBJECT (btnHelp), "clicked", G_CALLBACK (display_help), window);

    btnQuit = gtk_button_new_with_label ("Quit");
    gtk_widget_set_size_request (btnQuit, 250, 60);
    gtk_fixed_put (GTK_FIXED (fix), btnQuit, 410, 330);
    g_signal_connect (G_OBJECT (btnQuit), "clicked", G_CALLBACK (quit_bm), window);

    // Let's show everything
    gtk_widget_show_all (window);

    return GTK_WINDOW (window);
}


gint dbus_callback (const gchar * interface, const gchar * method,
		    GArray * arguments, gpointer data, osso_rpc_t * retval)
{
    printf ("bomberman dbus: %s, %s\n", interface, method);

    if (!strcmp (method, "top_application"))
	gtk_window_present (GTK_WINDOW (data));

    retval->type = DBUS_TYPE_INVALID;
    return OSSO_OK;
}

int main (int argc, char *argv[])
{
    osso_context_t *ctxt;
    osso_return_t ret;
    GtkWindow *window;

    ctxt = osso_initialize ("bomberman_app", PACKAGE_VERSION, TRUE, NULL);

    if (ctxt == NULL)
	{
	    fprintf (stderr, "osso_initialize failed.\n");
	    exit (1);
	}
    gtk_init (&argc, &argv);

    loadPrefs();

    window = bomberman_new ();

    ret = osso_rpc_set_default_cb_f (ctxt, dbus_callback, window);
    if (ret != OSSO_OK)
	{
	    fprintf (stderr, "osso_rpc_set_default_cb_f failed: %d.\n", ret);
	    exit (1);
	}
    gtk_main ();

    return 0;
}
