# -*- coding: utf-8 -*-
'''
Advanced Power Locale
2008-2009(c) Kirill Plyashkevich <ru.spirit@gmail.com>
'''

import gettext
gettext.textdomain('advanced-power')
_ = gettext.gettext

class Locale():

  current_locale = {
  'item-battery_status': _('Battery'),
  'battery_state_unknown': _('Unknown battery state'),
  'battery_state_very_low': _('Battery level is very low'),
  'battery_state_full': _('Battery is full'),
  'battery_state_charging': _('Battery is charging'),
  'battery_state_charger_disconn': _('Charger disconnected'),
  'confirm_reboot': _('Reboot the device?'),
  'confirm_shutdown': _('Shutdown the device?'),
  'time_days': _('d'),
  'time_hours': _('h'),
  'time_minutes': _('min'),
  'unknown': _('unknown'),
  'starting': _('Starting'),
  'item-timeleft_active': _('Active time'),
  'item-timeleft_idle':  _('Idle time'),
  'item-settings': _('Settings'),
  'item-cpu_frequency': _('CPU'),
  'item-cpu_governor_menu': _('CPU Policy'),
  'item-cpu_governor_conservative': _('conservative'),
  'item-cpu_governor_ondemand': _('ondemand'),
  'item-cpu_governor_null': _('null'),
  'item-cpu_governor_powersave': _('powersave'),
  'item-cpu_governor_performance': _('performance'),
  'item-device_mode_menu': _('Device mode'),
  'item-device_mode_normal': _('Normal mode'),
  'item-device_mode_flight': _('Flight mode'),
  'item-device_mode_flight_and_lock': _('Flight mode + Lock'),
  'item-device_mode_unknown': _('Unknown mode'),
  'item-device_lock': _('Lock screen and keys'),
  'item-reboot': _('Reboot'),
  'item-shutdown': _('Shutdown'),
  'item-os_version': _('OS Version'),
  'item-temperature': _('Temperature'),
  'item-light_sensor': _('Light sensor'),
  'item-bluetooth_mode_menu': _('Bluetooth'),
  'item-bluetooth_mode_unknown': _('Unknown mode'),
  'item-bluetooth_mode_off': _('Off'),
  'item-bluetooth_mode_discoverable': _('On (discoverable)'),
  'item-bluetooth_mode_connectable': _('On'),
  'item-bluetooth_mode_limited': _('On (limited)'),
  'item-uptime': _('Uptime'),
  'item-ram': _('RAM'),
  'item-swap': _('Swap'),
  'item-memory': _('Memory'),
  'item-swap_disabled': _('Swap is disabled'),
  'item-diskspace_menu': _('Disk Space'),
  'item-diskspace_title': _('Mounted drives'),
  'item-timeleft': _('Time Left'),
  'item-buttons_emulation_menu': _('HW Buttons'),
  'item-buttons-emu-home-p': _('Home'),
  'item-buttons-emu-home-lp': _('Home (Long press)'),
  'item-usb_mode_menu': _('USB'),
  'item-usb_mode_otg': _('OTG'),
  'item-usb_mode_host': _('Host'),
  'item-usb_mode_unknown': _('Unknown mode'),
  'item-run_command': _('Run command'),
  'item-run_command_in_terminal': _('In terminal'),
  'item-run_command_as_root': _('As root'),
  'title_settings': _('Advanced Power Settings'),
  'title_main': _('Main'),
  'title_items': _('Items'),
  'title_wrappers': _('Wrappers'),
  'title_events': _('Events'),
  'title_translation': _('Translation'),
  'title_about': _('About'),
  'settings-temperature-metric': _('Temperature metric'),
  'settings-current-theme': _('Theme'),
  'settings-play-sounds': _('Play sounds'),
  'settings-use-gtk-theme': _('Use GTK theme'),
  'settings-use-custom-low-battery-level': _('Use custom low battery level'),
  'settings-low-battery-level': _('Low battery level'),
  'settings-use-custom-sounds-volume': _('Use custom sounds volume'),
  'settings-sounds-volume': _('Sounds volume'),
  'wrappers-battery': _('Battery'),
  'wrappers-device_mode': _('Device mode'),
  'wrappers-bluetooth': _('Bluetooth'),
  'wrappers-usb_mode': _('USB mode'),
  'Russian': _('Russian'),
  'German': _('German'),
  'B': _('B'),
  'KB': _('KB'), 
  'MB': _('MB'),
  'GB': _('GB'),
  'MHz': _('MHz'),
  'lux': _('lux'),
  'apmd_start': _('Start APMD'),
  'apmd_starting': '%s APMD' % _('Starting'),
  'apmd_connecting': _('Connecting to APMD'),
  'apmd_disconnected': _('Disconnected from APMD'),
  'apmd_connected': _('Connected to APMD'),
  }

  @staticmethod
  def get(key):
    try:
      return Locale.current_locale[key]
    except KeyError:
      return key

  @staticmethod
  def get_text(text):
    return _(text)

  @staticmethod
  def get_item(key):
    return Locale.get('item-%s' % key)
