/*
    advanced-backlight -- Status bar plugin for Hildon
    -----------------------------------------
    
    - Supports rotation, brightness and volume.
    - Resembles the closed source status bar style "hildon-status-bar-popup".

    (C) 2008 Jonas Hurrelmann <j@outpo.st>.
    (C) 2008 Adam Harwell <aharwell@trinity.edu>.
    
    Randr handling has been ported from gpe-conf
    (C) 2002 Moray Allan <moray@sermisy.org>, Pierre TARDY <tardyp@free.fr>
        2003-2007 Florian Boor <florian.boor@kernelconcepts.de>.

    Minor parts where derived from bt-plugin.c
    (C) 2005 Nokia Corporation, Tomas Junnonen <tomas.junnonen@nokia.com>, 
        Jari Tenhunen <jari.tenhunen@nokia.com>.
 
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
    
*/

#ifndef ADVANCED_BACKLIGHT_PLUGIN_H
#define ADVANCED_BACKLIGHT_PLUGIN_H

#include <glib.h>

#define ADVANCED_BACKLIGHT_PLUGIN_TYPE            (advanced_backlight_plugin_get_type ())
#define ADVANCED_BACKLIGHT_PLUGIN(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), ADVANCED_BACKLIGHT_PLUGIN_TYPE, AdvancedBacklightPlugin))
#define ADVANCED_BACKLIGHT_PLUGIN_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  ADVANCED_BACKLIGHT_PLUGIN_TYPE, AdvancedBacklightPluginClass))
#define IS_ADVANCED_BACKLIGHT_PLUGIN(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ADVANCED_BACKLIGHT_PLUGIN_TYPE))
#define IS_ADVANCED_BACKLIGHT_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  ADVANCED_BACKLIGHT_PLUGIN_TYPE))
#define ADVANCED_BACKLIGHT_PLUGIN_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  ADVANCED_BACKLIGHT_PLUGIN_TYPE, AdvancedBacklightPluginClass))

typedef struct _AdvancedBacklightPlugin      AdvancedBacklightPlugin;
typedef struct _AdvancedBacklightPluginClass AdvancedBacklightPluginClass;

struct _AdvancedBacklightPlugin
{
  StatusbarItem parent;
};

struct _AdvancedBacklightPluginClass
{
  StatusbarItemClass parent_class;
};

GType advanced_backlight_plugin_get_type(void);

#endif /* !ADVANCED_BACKLIGHT_PLUGIN_H */
