description(
"This test checks whether various forms of postincrement expression are allowed."
);

var x = 0;
var y = 0;

shouldBe('x++', '0');
shouldBe('window.x++', '1');
shouldBe('window["x"]++', '2');
shouldBe('(x)++', '3');
shouldBe('(window.x)++', '4');
shouldBe('(window["x"])++', '5');
shouldBe('(y, x++)', '6');
shouldBe('((x))++', '7');
shouldBe('((window.x))++', '8');
shouldBe('((window["x"]))++', '9');

shouldThrow('(y, x)++');
shouldThrow('(true ? x : y)++');
shouldThrow('x++++');

var successfullyParsed = true;

