description("This test ensures that NaN is handled correctly when converting numeric expressions to booleans.");

shouldBe("NaN ? true : false", "false");
shouldBe("1 ? true : false", "true");
shouldBe("0 ? true : false", "false");
shouldBe("-1 ? true : false", "true");
shouldBe("1 * -1 ? true : false", "true");
shouldBe("1 * 0 ? true : false", "false");
shouldBe("1 * 1 ? true : false", "true");
shouldBe("1 / -1 ? true : false", "true");
shouldBe("1 / 0 ? true : false", "true");
shouldBe("1 / 1 ? true : false", "true");
shouldBe("1 % 2 ? true : false", "true");
shouldBe("1 % 1 ? true : false", "false");
shouldBe("1 + -1 ? true : false", "false");
shouldBe("1 + 0 ? true : false", "true");
shouldBe("1 + 1 ? true : false", "true");
shouldBe("1 - -1 ? true : false", "true");
shouldBe("1 - 0 ? true : false", "true");
shouldBe("1 - 1 ? true : false", "false");
shouldBe("1 & -1 ? true : false", "true");
shouldBe("1 & 0 ? true : false", "false");
shouldBe("1 & 1 ? true : false", "true");
shouldBe("1 | -1 ? true : false", "true");
shouldBe("1 | 0 ? true : false", "true");
shouldBe("1 | 1 ? true : false", "true");
shouldBe("1 ^ -1 ? true : false", "true");
shouldBe("1 ^ 0 ? true : false", "true");
shouldBe("1 ^ 1 ? true : false", "false");
shouldBe("NaN * -1 ? true : false", "false");
shouldBe("NaN * 0? true : false", "false");
shouldBe("NaN * 1? true : false", "false");
shouldBe("NaN / -1 ? true : false", "false");
shouldBe("NaN / 0? true : false", "false");
shouldBe("NaN / 1? true : false", "false");
shouldBe("NaN % -1 ? true : false", "false");
shouldBe("NaN % 0? true : false", "false");
shouldBe("NaN % 1? true : false", "false");
shouldBe("NaN + -1 ? true : false", "false");
shouldBe("NaN + 0? true : false", "false");
shouldBe("NaN + 1? true : false", "false");
shouldBe("NaN - -1 ? true : false", "false");
shouldBe("NaN - 0? true : false", "false");
shouldBe("NaN - 1? true : false", "false");
shouldBe("NaN & -1 ? true : false", "false");
shouldBe("NaN & 0? true : false", "false");
shouldBe("NaN & 1? true : false", "false");
shouldBe("NaN | -1 ? true : false", "true");
shouldBe("NaN | 0? true : false", "false");
shouldBe("NaN | 1? true : false", "true");
shouldBe("NaN ^ -1 ? true : false", "true");
shouldBe("NaN ^ 0? true : false", "false");
shouldBe("NaN ^ 1? true : false", "true");
shouldBe("+NaN ? true : false", "false");
shouldBe("-NaN ? true : false", "false");
shouldBe("NaN && true ? true : false", "false");
shouldBe("NaN && false ? true : false", "false");
shouldBe("NaN || true ? true : false", "true");
shouldBe("NaN || false ? true : false", "false");
shouldBe("(function(){var nan = NaN; return nan-- ? true : false})()", "false");
shouldBe("(function(){var nan = NaN; return nan++ ? true : false})()", "false");
shouldBe("(function(){var nan = NaN; return --nan ? true : false})()", "false");
shouldBe("(function(){var nan = NaN; return ++nan ? true : false})()", "false");
shouldBe("(function(){var Undefined = undefined; return Undefined-- ? true : false})()", "false");
shouldBe("(function(){var Undefined = undefined; return Undefined++ ? true : false})()", "false");
shouldBe("(function(){var Undefined = undefined; return --Undefined ? true : false})()", "false");
shouldBe("(function(){var Undefined = undefined; return ++Undefined ? true : false})()", "false");

var successfullyParsed = true;
