/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(XPATH)

#include "JSXPathResult.h"

#include <wtf/GetPtr.h>

#include "JSNode.h"
#include "KURL.h"
#include "Node.h"
#include "XPathResult.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSXPathResultTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "resultType", { (intptr_t)JSXPathResult::ResultTypeAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "stringValue", { (intptr_t)JSXPathResult::StringValueAttrNum }, DontDelete|ReadOnly, 0, &JSXPathResultTableEntries[16] },
    { 0, { 0 }, 0, 0, 0 },
    { "booleanValue", { (intptr_t)JSXPathResult::BooleanValueAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "numberValue", { (intptr_t)JSXPathResult::NumberValueAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "constructor", { (intptr_t)JSXPathResult::ConstructorAttrNum }, DontEnum, 0, 0 },
    { "singleNodeValue", { (intptr_t)JSXPathResult::SingleNodeValueAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "invalidIteratorState", { (intptr_t)JSXPathResult::InvalidIteratorStateAttrNum }, DontDelete|ReadOnly, 0, &JSXPathResultTableEntries[17] },
    { "snapshotLength", { (intptr_t)JSXPathResult::SnapshotLengthAttrNum }, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSXPathResultTable = 
{
    3, 18, JSXPathResultTableEntries, 15
};

/* Hash table for constructor */

static const HashEntry JSXPathResultConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "BOOLEAN_TYPE", { (intptr_t)3 }, DontDelete|ReadOnly, 0, 0 },
    { "NUMBER_TYPE", { (intptr_t)1 }, DontDelete|ReadOnly, 0, 0 },
    { "STRING_TYPE", { (intptr_t)2 }, DontDelete|ReadOnly, 0, 0 },
    { "ANY_TYPE", { (intptr_t)0 }, DontDelete|ReadOnly, 0, 0 },
    { "ORDERED_NODE_ITERATOR_TYPE", { (intptr_t)5 }, DontDelete|ReadOnly, 0, 0 },
    { "ANY_UNORDERED_NODE_TYPE", { (intptr_t)8 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "UNORDERED_NODE_SNAPSHOT_TYPE", { (intptr_t)6 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "FIRST_ORDERED_NODE_TYPE", { (intptr_t)9 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "UNORDERED_NODE_ITERATOR_TYPE", { (intptr_t)4 }, DontDelete|ReadOnly, 0, &JSXPathResultConstructorTableEntries[32] },
    { "ORDERED_NODE_SNAPSHOT_TYPE", { (intptr_t)7 }, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSXPathResultConstructorTable = 
{
    3, 33, JSXPathResultConstructorTableEntries, 31
};

class JSXPathResultConstructor : public DOMObject {
public:
    JSXPathResultConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSXPathResultPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSXPathResultConstructor::info = { "XPathResultConstructor", 0, &JSXPathResultConstructorTable };

bool JSXPathResultConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSXPathResultConstructor, DOMObject>(exec, &JSXPathResultConstructorTable, this, propertyName, slot);
}

JSValue* JSXPathResultConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSXPathResultPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "BOOLEAN_TYPE", { (intptr_t)3 }, DontDelete|ReadOnly, 0, 0 },
    { "NUMBER_TYPE", { (intptr_t)1 }, DontDelete|ReadOnly, 0, 0 },
    { "STRING_TYPE", { (intptr_t)2 }, DontDelete|ReadOnly, 0, 0 },
    { "ANY_TYPE", { (intptr_t)0 }, DontDelete|ReadOnly, 0, 0 },
    { "ORDERED_NODE_ITERATOR_TYPE", { (intptr_t)5 }, DontDelete|ReadOnly, 0, 0 },
    { "ANY_UNORDERED_NODE_TYPE", { (intptr_t)8 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "iterateNext", { (intptr_t)jsXPathResultPrototypeFunctionIterateNext }, DontDelete|Function, 0, 0 },
    { "snapshotItem", { (intptr_t)jsXPathResultPrototypeFunctionSnapshotItem }, DontDelete|Function, 1, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "UNORDERED_NODE_SNAPSHOT_TYPE", { (intptr_t)6 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "FIRST_ORDERED_NODE_TYPE", { (intptr_t)9 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "UNORDERED_NODE_ITERATOR_TYPE", { (intptr_t)4 }, DontDelete|ReadOnly, 0, &JSXPathResultPrototypeTableEntries[32] },
    { "ORDERED_NODE_SNAPSHOT_TYPE", { (intptr_t)7 }, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSXPathResultPrototypeTable = 
{
    3, 33, JSXPathResultPrototypeTableEntries, 31
};

const ClassInfo JSXPathResultPrototype::info = { "XPathResultPrototype", 0, &JSXPathResultPrototypeTable };

JSObject* JSXPathResultPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSXPathResultPrototype>(exec, "[[JSXPathResult.prototype]]");
}

bool JSXPathResultPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSXPathResultPrototype, JSObject>(exec, &JSXPathResultPrototypeTable, this, propertyName, slot);
}

JSValue* JSXPathResultPrototype::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

const ClassInfo JSXPathResult::info = { "XPathResult", 0, &JSXPathResultTable };

JSXPathResult::JSXPathResult(JSObject* prototype, XPathResult* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSXPathResult::~JSXPathResult()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSXPathResult::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSXPathResult, Base>(exec, &JSXPathResultTable, this, propertyName, slot);
}

JSValue* JSXPathResult::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case ResultTypeAttrNum: {
        XPathResult* imp = static_cast<XPathResult*>(impl());
        return jsNumber(imp->resultType());
    }
    case NumberValueAttrNum: {
        ExceptionCode ec = 0;
        XPathResult* imp = static_cast<XPathResult*>(impl());
        KJS::JSValue* result = jsNumber(imp->numberValue(ec));
        setDOMException(exec, ec);
        return result;
    }
    case StringValueAttrNum: {
        ExceptionCode ec = 0;
        XPathResult* imp = static_cast<XPathResult*>(impl());
        KJS::JSValue* result = jsString(imp->stringValue(ec));
        setDOMException(exec, ec);
        return result;
    }
    case BooleanValueAttrNum: {
        ExceptionCode ec = 0;
        XPathResult* imp = static_cast<XPathResult*>(impl());
        KJS::JSValue* result = jsBoolean(imp->booleanValue(ec));
        setDOMException(exec, ec);
        return result;
    }
    case SingleNodeValueAttrNum: {
        ExceptionCode ec = 0;
        XPathResult* imp = static_cast<XPathResult*>(impl());
        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->singleNodeValue(ec)));
        setDOMException(exec, ec);
        return result;
    }
    case InvalidIteratorStateAttrNum: {
        XPathResult* imp = static_cast<XPathResult*>(impl());
        return jsBoolean(imp->invalidIteratorState());
    }
    case SnapshotLengthAttrNum: {
        ExceptionCode ec = 0;
        XPathResult* imp = static_cast<XPathResult*>(impl());
        KJS::JSValue* result = jsNumber(imp->snapshotLength(ec));
        setDOMException(exec, ec);
        return result;
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSXPathResult::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSXPathResultConstructor>(exec, "[[XPathResult.constructor]]");
}

JSValue* jsXPathResultPrototypeFunctionIterateNext(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSXPathResult::info))
        return throwError(exec, TypeError);
    JSXPathResult* castedThisObj = static_cast<JSXPathResult*>(thisObj);
    XPathResult* imp = static_cast<XPathResult*>(castedThisObj->impl());
    ExceptionCode ec = 0;


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->iterateNext(ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsXPathResultPrototypeFunctionSnapshotItem(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSXPathResult::info))
        return throwError(exec, TypeError);
    JSXPathResult* castedThisObj = static_cast<JSXPathResult*>(thisObj);
    XPathResult* imp = static_cast<XPathResult*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    unsigned index = args[0]->toInt32(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->snapshotItem(index, ec)));
    setDOMException(exec, ec);
    return result;
}

KJS::JSValue* toJS(KJS::ExecState* exec, XPathResult* obj)
{
    return cacheDOMObject<XPathResult, JSXPathResult, JSXPathResultPrototype>(exec, obj);
}
XPathResult* toXPathResult(KJS::JSValue* val)
{
    return val->isObject(&JSXPathResult::info) ? static_cast<JSXPathResult*>(val)->impl() : 0;
}

}

#endif // ENABLE(XPATH)
