/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(XPATH)

#include "JSXPathExpression.h"

#include <wtf/GetPtr.h>

#include "JSNode.h"
#include "JSXPathResult.h"
#include "XPathExpression.h"
#include "XPathResult.h"

using namespace KJS;

namespace WebCore {

/* Hash table for prototype */

static const HashEntry JSXPathExpressionPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "evaluate", { (intptr_t)jsXPathExpressionPrototypeFunctionEvaluate }, DontDelete|Function, 3, 0 }
};

static const HashTable JSXPathExpressionPrototypeTable = 
{
    3, 2, JSXPathExpressionPrototypeTableEntries, 1
};

const ClassInfo JSXPathExpressionPrototype::info = { "XPathExpressionPrototype", 0, &JSXPathExpressionPrototypeTable };

JSObject* JSXPathExpressionPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSXPathExpressionPrototype>(exec, "[[JSXPathExpression.prototype]]");
}

bool JSXPathExpressionPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSXPathExpressionPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSXPathExpression::info = { "XPathExpression", 0, 0 };

JSXPathExpression::JSXPathExpression(JSObject* prototype, XPathExpression* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSXPathExpression::~JSXPathExpression()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

JSValue* jsXPathExpressionPrototypeFunctionEvaluate(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSXPathExpression::info))
        return throwError(exec, TypeError);
    JSXPathExpression* castedThisObj = static_cast<JSXPathExpression*>(thisObj);
    XPathExpression* imp = static_cast<XPathExpression*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* contextNode = toNode(args[0]);
    unsigned short type = args[1]->toInt32(exec);
    XPathResult* inResult = toXPathResult(args[2]);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->evaluate(contextNode, type, inResult, ec)));
    setDOMException(exec, ec);
    return result;
}

KJS::JSValue* toJS(KJS::ExecState* exec, XPathExpression* obj)
{
    return cacheDOMObject<XPathExpression, JSXPathExpression, JSXPathExpressionPrototype>(exec, obj);
}
XPathExpression* toXPathExpression(KJS::JSValue* val)
{
    return val->isObject(&JSXPathExpression::info) ? static_cast<JSXPathExpression*>(val)->impl() : 0;
}

}

#endif // ENABLE(XPATH)
