/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(XPATH)

#include "JSXPathException.h"

#include <wtf/GetPtr.h>

#include "KURL.h"
#include "XPathException.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSXPathExceptionTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "code", { (intptr_t)JSXPathException::CodeAttrNum }, DontDelete|ReadOnly, 0, &JSXPathExceptionTableEntries[8] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "message", { (intptr_t)JSXPathException::MessageAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "name", { (intptr_t)JSXPathException::NameAttrNum }, DontDelete|ReadOnly, 0, &JSXPathExceptionTableEntries[9] },
    { "constructor", { (intptr_t)JSXPathException::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSXPathExceptionTable = 
{
    3, 10, JSXPathExceptionTableEntries, 7
};

/* Hash table for constructor */

static const HashEntry JSXPathExceptionConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "INVALID_EXPRESSION_ERR", { (intptr_t)51 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "TYPE_ERR", { (intptr_t)52 }, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSXPathExceptionConstructorTable = 
{
    3, 4, JSXPathExceptionConstructorTableEntries, 3
};

class JSXPathExceptionConstructor : public DOMObject {
public:
    JSXPathExceptionConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSXPathExceptionPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSXPathExceptionConstructor::info = { "XPathExceptionConstructor", 0, &JSXPathExceptionConstructorTable };

bool JSXPathExceptionConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSXPathExceptionConstructor, DOMObject>(exec, &JSXPathExceptionConstructorTable, this, propertyName, slot);
}

JSValue* JSXPathExceptionConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSXPathExceptionPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "INVALID_EXPRESSION_ERR", { (intptr_t)51 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "toString", { (intptr_t)jsXPathExceptionPrototypeFunctionToString }, DontDelete|DontEnum|Function, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "TYPE_ERR", { (intptr_t)52 }, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSXPathExceptionPrototypeTable = 
{
    3, 8, JSXPathExceptionPrototypeTableEntries, 7
};

const ClassInfo JSXPathExceptionPrototype::info = { "XPathExceptionPrototype", 0, &JSXPathExceptionPrototypeTable };

JSObject* JSXPathExceptionPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSXPathExceptionPrototype>(exec, "[[JSXPathException.prototype]]");
}

bool JSXPathExceptionPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSXPathExceptionPrototype, JSObject>(exec, &JSXPathExceptionPrototypeTable, this, propertyName, slot);
}

JSValue* JSXPathExceptionPrototype::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

const ClassInfo JSXPathException::info = { "XPathException", 0, &JSXPathExceptionTable };

JSXPathException::JSXPathException(JSObject* prototype, XPathException* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSXPathException::~JSXPathException()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSXPathException::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSXPathException, Base>(exec, &JSXPathExceptionTable, this, propertyName, slot);
}

JSValue* JSXPathException::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case CodeAttrNum: {
        XPathException* imp = static_cast<XPathException*>(impl());
        return jsNumber(imp->code());
    }
    case NameAttrNum: {
        XPathException* imp = static_cast<XPathException*>(impl());
        return jsString(imp->name());
    }
    case MessageAttrNum: {
        XPathException* imp = static_cast<XPathException*>(impl());
        return jsString(imp->message());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSXPathException::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSXPathExceptionConstructor>(exec, "[[XPathException.constructor]]");
}

JSValue* jsXPathExceptionPrototypeFunctionToString(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSXPathException::info))
        return throwError(exec, TypeError);
    JSXPathException* castedThisObj = static_cast<JSXPathException*>(thisObj);
    XPathException* imp = static_cast<XPathException*>(castedThisObj->impl());


    KJS::JSValue* result = jsString(imp->toString());
    return result;
}

KJS::JSValue* toJS(KJS::ExecState* exec, XPathException* obj)
{
    return cacheDOMObject<XPathException, JSXPathException, JSXPathExceptionPrototype>(exec, obj);
}
XPathException* toXPathException(KJS::JSValue* val)
{
    return val->isObject(&JSXPathException::info) ? static_cast<JSXPathException*>(val)->impl() : 0;
}

}

#endif // ENABLE(XPATH)
