/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSXMLHttpRequestException.h"

#include <wtf/GetPtr.h>

#include "KURL.h"
#include "XMLHttpRequestException.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSXMLHttpRequestExceptionTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "code", { (intptr_t)JSXMLHttpRequestException::CodeAttrNum }, DontDelete|ReadOnly, 0, &JSXMLHttpRequestExceptionTableEntries[8] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "message", { (intptr_t)JSXMLHttpRequestException::MessageAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "name", { (intptr_t)JSXMLHttpRequestException::NameAttrNum }, DontDelete|ReadOnly, 0, &JSXMLHttpRequestExceptionTableEntries[9] },
    { "constructor", { (intptr_t)JSXMLHttpRequestException::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSXMLHttpRequestExceptionTable = 
{
    3, 10, JSXMLHttpRequestExceptionTableEntries, 7
};

/* Hash table for constructor */

static const HashEntry JSXMLHttpRequestExceptionConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "NETWORK_ERR", { (intptr_t)101 }, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSXMLHttpRequestExceptionConstructorTable = 
{
    3, 2, JSXMLHttpRequestExceptionConstructorTableEntries, 1
};

class JSXMLHttpRequestExceptionConstructor : public DOMObject {
public:
    JSXMLHttpRequestExceptionConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSXMLHttpRequestExceptionPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSXMLHttpRequestExceptionConstructor::info = { "XMLHttpRequestExceptionConstructor", 0, &JSXMLHttpRequestExceptionConstructorTable };

bool JSXMLHttpRequestExceptionConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSXMLHttpRequestExceptionConstructor, DOMObject>(exec, &JSXMLHttpRequestExceptionConstructorTable, this, propertyName, slot);
}

JSValue* JSXMLHttpRequestExceptionConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSXMLHttpRequestExceptionPrototypeTableEntries[] =
{
    { "toString", { (intptr_t)jsXMLHttpRequestExceptionPrototypeFunctionToString }, DontDelete|DontEnum|Function, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "NETWORK_ERR", { (intptr_t)101 }, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSXMLHttpRequestExceptionPrototypeTable = 
{
    3, 4, JSXMLHttpRequestExceptionPrototypeTableEntries, 3
};

const ClassInfo JSXMLHttpRequestExceptionPrototype::info = { "XMLHttpRequestExceptionPrototype", 0, &JSXMLHttpRequestExceptionPrototypeTable };

JSObject* JSXMLHttpRequestExceptionPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSXMLHttpRequestExceptionPrototype>(exec, "[[JSXMLHttpRequestException.prototype]]");
}

bool JSXMLHttpRequestExceptionPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSXMLHttpRequestExceptionPrototype, JSObject>(exec, &JSXMLHttpRequestExceptionPrototypeTable, this, propertyName, slot);
}

JSValue* JSXMLHttpRequestExceptionPrototype::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

const ClassInfo JSXMLHttpRequestException::info = { "XMLHttpRequestException", 0, &JSXMLHttpRequestExceptionTable };

JSXMLHttpRequestException::JSXMLHttpRequestException(JSObject* prototype, XMLHttpRequestException* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSXMLHttpRequestException::~JSXMLHttpRequestException()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSXMLHttpRequestException::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSXMLHttpRequestException, Base>(exec, &JSXMLHttpRequestExceptionTable, this, propertyName, slot);
}

JSValue* JSXMLHttpRequestException::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case CodeAttrNum: {
        XMLHttpRequestException* imp = static_cast<XMLHttpRequestException*>(impl());
        return jsNumber(imp->code());
    }
    case NameAttrNum: {
        XMLHttpRequestException* imp = static_cast<XMLHttpRequestException*>(impl());
        return jsString(imp->name());
    }
    case MessageAttrNum: {
        XMLHttpRequestException* imp = static_cast<XMLHttpRequestException*>(impl());
        return jsString(imp->message());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSXMLHttpRequestException::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSXMLHttpRequestExceptionConstructor>(exec, "[[XMLHttpRequestException.constructor]]");
}

JSValue* jsXMLHttpRequestExceptionPrototypeFunctionToString(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSXMLHttpRequestException::info))
        return throwError(exec, TypeError);
    JSXMLHttpRequestException* castedThisObj = static_cast<JSXMLHttpRequestException*>(thisObj);
    XMLHttpRequestException* imp = static_cast<XMLHttpRequestException*>(castedThisObj->impl());


    KJS::JSValue* result = jsString(imp->toString());
    return result;
}

KJS::JSValue* toJS(KJS::ExecState* exec, XMLHttpRequestException* obj)
{
    return cacheDOMObject<XMLHttpRequestException, JSXMLHttpRequestException, JSXMLHttpRequestExceptionPrototype>(exec, obj);
}
XMLHttpRequestException* toXMLHttpRequestException(KJS::JSValue* val)
{
    return val->isObject(&JSXMLHttpRequestException::info) ? static_cast<JSXMLHttpRequestException*>(val)->impl() : 0;
}

}
