/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSUIEvent.h"

#include <wtf/GetPtr.h>

#include "DOMWindow.h"
#include "JSDOMWindow.h"
#include "UIEvent.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSUIEventTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "pageY", { (intptr_t)JSUIEvent::PageYAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "layerY", { (intptr_t)JSUIEvent::LayerYAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "pageX", { (intptr_t)JSUIEvent::PageXAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "charCode", { (intptr_t)JSUIEvent::CharCodeAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "view", { (intptr_t)JSUIEvent::ViewAttrNum }, DontDelete|ReadOnly, 0, &JSUIEventTableEntries[32] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "which", { (intptr_t)JSUIEvent::WhichAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "keyCode", { (intptr_t)JSUIEvent::KeyCodeAttrNum }, DontDelete|ReadOnly, 0, &JSUIEventTableEntries[33] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "detail", { (intptr_t)JSUIEvent::DetailAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "layerX", { (intptr_t)JSUIEvent::LayerXAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "constructor", { (intptr_t)JSUIEvent::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSUIEventTable = 
{
    3, 34, JSUIEventTableEntries, 31
};

/* Hash table for constructor */

static const HashEntry JSUIEventConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSUIEventConstructorTable = 
{
    3, 1, JSUIEventConstructorTableEntries, 0
};

class JSUIEventConstructor : public DOMObject {
public:
    JSUIEventConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSUIEventPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSUIEventConstructor::info = { "UIEventConstructor", 0, &JSUIEventConstructorTable };

bool JSUIEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSUIEventConstructor, DOMObject>(exec, &JSUIEventConstructorTable, this, propertyName, slot);
}

JSValue* JSUIEventConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSUIEventPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "initUIEvent", { (intptr_t)jsUIEventPrototypeFunctionInitUIEvent }, DontDelete|Function, 5, 0 }
};

static const HashTable JSUIEventPrototypeTable = 
{
    3, 2, JSUIEventPrototypeTableEntries, 1
};

const ClassInfo JSUIEventPrototype::info = { "UIEventPrototype", 0, &JSUIEventPrototypeTable };

JSObject* JSUIEventPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSUIEventPrototype>(exec, "[[JSUIEvent.prototype]]");
}

bool JSUIEventPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSUIEventPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSUIEvent::info = { "UIEvent", &JSEvent::info, &JSUIEventTable };

JSUIEvent::JSUIEvent(JSObject* prototype, UIEvent* impl)
    : JSEvent(prototype, impl)
{
}

bool JSUIEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSUIEvent, Base>(exec, &JSUIEventTable, this, propertyName, slot);
}

JSValue* JSUIEvent::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case ViewAttrNum: {
        UIEvent* imp = static_cast<UIEvent*>(impl());
        return toJS(exec, WTF::getPtr(imp->view()));
    }
    case DetailAttrNum: {
        UIEvent* imp = static_cast<UIEvent*>(impl());
        return jsNumber(imp->detail());
    }
    case KeyCodeAttrNum: {
        UIEvent* imp = static_cast<UIEvent*>(impl());
        return jsNumber(imp->keyCode());
    }
    case CharCodeAttrNum: {
        UIEvent* imp = static_cast<UIEvent*>(impl());
        return jsNumber(imp->charCode());
    }
    case LayerXAttrNum: {
        UIEvent* imp = static_cast<UIEvent*>(impl());
        return jsNumber(imp->layerX());
    }
    case LayerYAttrNum: {
        UIEvent* imp = static_cast<UIEvent*>(impl());
        return jsNumber(imp->layerY());
    }
    case PageXAttrNum: {
        UIEvent* imp = static_cast<UIEvent*>(impl());
        return jsNumber(imp->pageX());
    }
    case PageYAttrNum: {
        UIEvent* imp = static_cast<UIEvent*>(impl());
        return jsNumber(imp->pageY());
    }
    case WhichAttrNum: {
        UIEvent* imp = static_cast<UIEvent*>(impl());
        return jsNumber(imp->which());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSUIEvent::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSUIEventConstructor>(exec, "[[UIEvent.constructor]]");
}

JSValue* jsUIEventPrototypeFunctionInitUIEvent(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSUIEvent::info))
        return throwError(exec, TypeError);
    JSUIEvent* castedThisObj = static_cast<JSUIEvent*>(thisObj);
    UIEvent* imp = static_cast<UIEvent*>(castedThisObj->impl());
    AtomicString type = args[0]->toString(exec);
    bool canBubble = args[1]->toBoolean(exec);
    bool cancelable = args[2]->toBoolean(exec);
    DOMWindow* view = toDOMWindow(args[3]);
    int detail = args[4]->toInt32(exec);

    imp->initUIEvent(type, canBubble, cancelable, view, detail);
    return jsUndefined();
}


}
