/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSTreeWalker_H
#define JSTreeWalker_H

#include "kjs_binding.h"
#include <kjs/JSGlobalObject.h>
#include <kjs/object_object.h>

namespace WebCore {

class TreeWalker;

class JSTreeWalker : public DOMObject {
    typedef DOMObject Base;
public:
    JSTreeWalker(KJS::JSObject* prototype, TreeWalker*);
    virtual ~JSTreeWalker();
    virtual bool getOwnPropertySlot(KJS::ExecState*, const KJS::Identifier& propertyName, KJS::PropertySlot&);
    KJS::JSValue* getValueProperty(KJS::ExecState*, int token) const;
    virtual void put(KJS::ExecState*, const KJS::Identifier& propertyName, KJS::JSValue*);
    void putValueProperty(KJS::ExecState*, int, KJS::JSValue*);
    virtual const KJS::ClassInfo* classInfo() const { return &info; }
    static const KJS::ClassInfo info;

    virtual void mark();

    enum {
        // Attributes
        RootAttrNum, WhatToShowAttrNum, FilterAttrNum, ExpandEntityReferencesAttrNum, 
        CurrentNodeAttrNum, 
    };

    // Custom functions
    KJS::JSValue* parentNode(KJS::ExecState*, const KJS::List&);
    KJS::JSValue* firstChild(KJS::ExecState*, const KJS::List&);
    KJS::JSValue* lastChild(KJS::ExecState*, const KJS::List&);
    KJS::JSValue* previousSibling(KJS::ExecState*, const KJS::List&);
    KJS::JSValue* nextSibling(KJS::ExecState*, const KJS::List&);
    KJS::JSValue* previousNode(KJS::ExecState*, const KJS::List&);
    KJS::JSValue* nextNode(KJS::ExecState*, const KJS::List&);
    TreeWalker* impl() const { return m_impl.get(); }

private:
    RefPtr<TreeWalker> m_impl;
};

KJS::JSValue* toJS(KJS::ExecState*, TreeWalker*);
TreeWalker* toTreeWalker(KJS::JSValue*);

class JSTreeWalkerPrototype : public KJS::JSObject {
public:
    static KJS::JSObject* self(KJS::ExecState* exec);
    virtual const KJS::ClassInfo* classInfo() const { return &info; }
    static const KJS::ClassInfo info;
    bool getOwnPropertySlot(KJS::ExecState*, const KJS::Identifier&, KJS::PropertySlot&);
    JSTreeWalkerPrototype(KJS::ExecState* exec)
        : KJS::JSObject(exec->lexicalGlobalObject()->objectPrototype()) { }
};

// Functions

KJS::JSValue* jsTreeWalkerPrototypeFunctionParentNode(KJS::ExecState*, KJS::JSObject*, const KJS::List&);
KJS::JSValue* jsTreeWalkerPrototypeFunctionFirstChild(KJS::ExecState*, KJS::JSObject*, const KJS::List&);
KJS::JSValue* jsTreeWalkerPrototypeFunctionLastChild(KJS::ExecState*, KJS::JSObject*, const KJS::List&);
KJS::JSValue* jsTreeWalkerPrototypeFunctionPreviousSibling(KJS::ExecState*, KJS::JSObject*, const KJS::List&);
KJS::JSValue* jsTreeWalkerPrototypeFunctionNextSibling(KJS::ExecState*, KJS::JSObject*, const KJS::List&);
KJS::JSValue* jsTreeWalkerPrototypeFunctionPreviousNode(KJS::ExecState*, KJS::JSObject*, const KJS::List&);
KJS::JSValue* jsTreeWalkerPrototypeFunctionNextNode(KJS::ExecState*, KJS::JSObject*, const KJS::List&);
} // namespace WebCore

#endif
