/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSTreeWalker.h"

#include <wtf/GetPtr.h>

#include "JSNode.h"
#include "JSNodeFilter.h"
#include "Node.h"
#include "NodeFilter.h"
#include "TreeWalker.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSTreeWalkerTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "currentNode", { (intptr_t)JSTreeWalker::CurrentNodeAttrNum }, DontDelete, 0, 0 },
    { "whatToShow", { (intptr_t)JSTreeWalker::WhatToShowAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "root", { (intptr_t)JSTreeWalker::RootAttrNum }, DontDelete|ReadOnly, 0, &JSTreeWalkerTableEntries[16] },
    { 0, { 0 }, 0, 0, 0 },
    { "filter", { (intptr_t)JSTreeWalker::FilterAttrNum }, DontDelete|ReadOnly, 0, &JSTreeWalkerTableEntries[17] },
    { "expandEntityReferences", { (intptr_t)JSTreeWalker::ExpandEntityReferencesAttrNum }, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSTreeWalkerTable = 
{
    3, 18, JSTreeWalkerTableEntries, 15
};

/* Hash table for prototype */

static const HashEntry JSTreeWalkerPrototypeTableEntries[] =
{
    { "nextNode", { (intptr_t)jsTreeWalkerPrototypeFunctionNextNode }, DontDelete|Function, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "previousSibling", { (intptr_t)jsTreeWalkerPrototypeFunctionPreviousSibling }, DontDelete|Function, 0, 0 },
    { "lastChild", { (intptr_t)jsTreeWalkerPrototypeFunctionLastChild }, DontDelete|Function, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "parentNode", { (intptr_t)jsTreeWalkerPrototypeFunctionParentNode }, DontDelete|Function, 0, 0 },
    { "previousNode", { (intptr_t)jsTreeWalkerPrototypeFunctionPreviousNode }, DontDelete|Function, 0, 0 },
    { "firstChild", { (intptr_t)jsTreeWalkerPrototypeFunctionFirstChild }, DontDelete|Function, 0, 0 },
    { "nextSibling", { (intptr_t)jsTreeWalkerPrototypeFunctionNextSibling }, DontDelete|Function, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSTreeWalkerPrototypeTable = 
{
    3, 16, JSTreeWalkerPrototypeTableEntries, 15
};

const ClassInfo JSTreeWalkerPrototype::info = { "TreeWalkerPrototype", 0, &JSTreeWalkerPrototypeTable };

JSObject* JSTreeWalkerPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSTreeWalkerPrototype>(exec, "[[JSTreeWalker.prototype]]");
}

bool JSTreeWalkerPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSTreeWalkerPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSTreeWalker::info = { "TreeWalker", 0, &JSTreeWalkerTable };

JSTreeWalker::JSTreeWalker(JSObject* prototype, TreeWalker* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSTreeWalker::~JSTreeWalker()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSTreeWalker::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSTreeWalker, Base>(exec, &JSTreeWalkerTable, this, propertyName, slot);
}

JSValue* JSTreeWalker::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case RootAttrNum: {
        TreeWalker* imp = static_cast<TreeWalker*>(impl());
        return toJS(exec, WTF::getPtr(imp->root()));
    }
    case WhatToShowAttrNum: {
        TreeWalker* imp = static_cast<TreeWalker*>(impl());
        return jsNumber(imp->whatToShow());
    }
    case FilterAttrNum: {
        TreeWalker* imp = static_cast<TreeWalker*>(impl());
        return toJS(exec, WTF::getPtr(imp->filter()));
    }
    case ExpandEntityReferencesAttrNum: {
        TreeWalker* imp = static_cast<TreeWalker*>(impl());
        return jsBoolean(imp->expandEntityReferences());
    }
    case CurrentNodeAttrNum: {
        TreeWalker* imp = static_cast<TreeWalker*>(impl());
        return toJS(exec, WTF::getPtr(imp->currentNode()));
    }
    }
    return 0;
}

void JSTreeWalker::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSTreeWalker, Base>(exec, propertyName, value, &JSTreeWalkerTable, this);
}

void JSTreeWalker::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case CurrentNodeAttrNum: {
        TreeWalker* imp = static_cast<TreeWalker*>(impl());
        ExceptionCode ec = 0;
        imp->setCurrentNode(toNode(value), ec);
        setDOMException(exec, ec);
        break;
    }
    }
}

JSValue* jsTreeWalkerPrototypeFunctionParentNode(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSTreeWalker::info))
        return throwError(exec, TypeError);
    JSTreeWalker* castedThisObj = static_cast<JSTreeWalker*>(thisObj);
    return castedThisObj->parentNode(exec, args);
}

JSValue* jsTreeWalkerPrototypeFunctionFirstChild(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSTreeWalker::info))
        return throwError(exec, TypeError);
    JSTreeWalker* castedThisObj = static_cast<JSTreeWalker*>(thisObj);
    return castedThisObj->firstChild(exec, args);
}

JSValue* jsTreeWalkerPrototypeFunctionLastChild(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSTreeWalker::info))
        return throwError(exec, TypeError);
    JSTreeWalker* castedThisObj = static_cast<JSTreeWalker*>(thisObj);
    return castedThisObj->lastChild(exec, args);
}

JSValue* jsTreeWalkerPrototypeFunctionPreviousSibling(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSTreeWalker::info))
        return throwError(exec, TypeError);
    JSTreeWalker* castedThisObj = static_cast<JSTreeWalker*>(thisObj);
    return castedThisObj->previousSibling(exec, args);
}

JSValue* jsTreeWalkerPrototypeFunctionNextSibling(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSTreeWalker::info))
        return throwError(exec, TypeError);
    JSTreeWalker* castedThisObj = static_cast<JSTreeWalker*>(thisObj);
    return castedThisObj->nextSibling(exec, args);
}

JSValue* jsTreeWalkerPrototypeFunctionPreviousNode(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSTreeWalker::info))
        return throwError(exec, TypeError);
    JSTreeWalker* castedThisObj = static_cast<JSTreeWalker*>(thisObj);
    return castedThisObj->previousNode(exec, args);
}

JSValue* jsTreeWalkerPrototypeFunctionNextNode(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSTreeWalker::info))
        return throwError(exec, TypeError);
    JSTreeWalker* castedThisObj = static_cast<JSTreeWalker*>(thisObj);
    return castedThisObj->nextNode(exec, args);
}

KJS::JSValue* toJS(KJS::ExecState* exec, TreeWalker* obj)
{
    return cacheDOMObject<TreeWalker, JSTreeWalker, JSTreeWalkerPrototype>(exec, obj);
}
TreeWalker* toTreeWalker(KJS::JSValue* val)
{
    return val->isObject(&JSTreeWalker::info) ? static_cast<JSTreeWalker*>(val)->impl() : 0;
}

}
