/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSTextEvent.h"

#include <wtf/GetPtr.h>

#include "JSDOMWindow.h"
#include "KURL.h"
#include "TextEvent.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSTextEventTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "constructor", { (intptr_t)JSTextEvent::ConstructorAttrNum }, DontEnum, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "data", { (intptr_t)JSTextEvent::DataAttrNum }, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSTextEventTable = 
{
    3, 4, JSTextEventTableEntries, 3
};

/* Hash table for constructor */

static const HashEntry JSTextEventConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSTextEventConstructorTable = 
{
    3, 1, JSTextEventConstructorTableEntries, 0
};

class JSTextEventConstructor : public DOMObject {
public:
    JSTextEventConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSTextEventPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSTextEventConstructor::info = { "TextEventConstructor", 0, &JSTextEventConstructorTable };

bool JSTextEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSTextEventConstructor, DOMObject>(exec, &JSTextEventConstructorTable, this, propertyName, slot);
}

JSValue* JSTextEventConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSTextEventPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "initTextEvent", { (intptr_t)jsTextEventPrototypeFunctionInitTextEvent }, DontDelete|Function, 5, 0 }
};

static const HashTable JSTextEventPrototypeTable = 
{
    3, 2, JSTextEventPrototypeTableEntries, 1
};

const ClassInfo JSTextEventPrototype::info = { "TextEventPrototype", 0, &JSTextEventPrototypeTable };

JSObject* JSTextEventPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSTextEventPrototype>(exec, "[[JSTextEvent.prototype]]");
}

bool JSTextEventPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSTextEventPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSTextEvent::info = { "TextEvent", &JSUIEvent::info, &JSTextEventTable };

JSTextEvent::JSTextEvent(JSObject* prototype, TextEvent* impl)
    : JSUIEvent(prototype, impl)
{
}

bool JSTextEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSTextEvent, Base>(exec, &JSTextEventTable, this, propertyName, slot);
}

JSValue* JSTextEvent::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case DataAttrNum: {
        TextEvent* imp = static_cast<TextEvent*>(impl());
        return jsString(imp->data());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSTextEvent::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSTextEventConstructor>(exec, "[[TextEvent.constructor]]");
}

JSValue* jsTextEventPrototypeFunctionInitTextEvent(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSTextEvent::info))
        return throwError(exec, TypeError);
    JSTextEvent* castedThisObj = static_cast<JSTextEvent*>(thisObj);
    TextEvent* imp = static_cast<TextEvent*>(castedThisObj->impl());
    String typeArg = args[0]->toString(exec);
    bool canBubbleArg = args[1]->toBoolean(exec);
    bool cancelableArg = args[2]->toBoolean(exec);
    DOMWindow* viewArg = toDOMWindow(args[3]);
    String dataArg = args[4]->toString(exec);

    imp->initTextEvent(typeArg, canBubbleArg, cancelableArg, viewArg, dataArg);
    return jsUndefined();
}


}
