/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSStyleSheetList.h"

#include <wtf/GetPtr.h>

#include <kjs/PropertyNameArray.h>
#include "AtomicString.h"
#include "JSStyleSheet.h"
#include "StyleSheet.h"
#include "StyleSheetList.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSStyleSheetListTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "length", { (intptr_t)JSStyleSheetList::LengthAttrNum }, DontDelete|ReadOnly, 0, &JSStyleSheetListTableEntries[4] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "constructor", { (intptr_t)JSStyleSheetList::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSStyleSheetListTable = 
{
    3, 5, JSStyleSheetListTableEntries, 3
};

/* Hash table for constructor */

static const HashEntry JSStyleSheetListConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSStyleSheetListConstructorTable = 
{
    3, 1, JSStyleSheetListConstructorTableEntries, 0
};

class JSStyleSheetListConstructor : public DOMObject {
public:
    JSStyleSheetListConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSStyleSheetListPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSStyleSheetListConstructor::info = { "StyleSheetListConstructor", 0, &JSStyleSheetListConstructorTable };

bool JSStyleSheetListConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSStyleSheetListConstructor, DOMObject>(exec, &JSStyleSheetListConstructorTable, this, propertyName, slot);
}

JSValue* JSStyleSheetListConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSStyleSheetListPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "item", { (intptr_t)jsStyleSheetListPrototypeFunctionItem }, DontDelete|Function, 1, 0 }
};

static const HashTable JSStyleSheetListPrototypeTable = 
{
    3, 2, JSStyleSheetListPrototypeTableEntries, 1
};

const ClassInfo JSStyleSheetListPrototype::info = { "StyleSheetListPrototype", 0, &JSStyleSheetListPrototypeTable };

JSObject* JSStyleSheetListPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSStyleSheetListPrototype>(exec, "[[JSStyleSheetList.prototype]]");
}

bool JSStyleSheetListPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSStyleSheetListPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSStyleSheetList::info = { "StyleSheetList", 0, &JSStyleSheetListTable };

JSStyleSheetList::JSStyleSheetList(JSObject* prototype, StyleSheetList* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSStyleSheetList::~JSStyleSheetList()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSStyleSheetList::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    const HashEntry* entry = Lookup::findEntry(&JSStyleSheetListTable, propertyName);
    if (entry) {
        slot.setStaticEntry(this, entry, staticValueGetter<JSStyleSheetList>);
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<StyleSheetList*>(impl())->length()) {
        slot.setCustomIndex(this, index, indexGetter);
        return true;
    }
    if (canGetItemsForName(exec, static_cast<StyleSheetList*>(impl()), propertyName)) {
        slot.setCustom(this, nameGetter);
        return true;
    }
    return getStaticValueSlot<JSStyleSheetList, Base>(exec, &JSStyleSheetListTable, this, propertyName, slot);
}

bool JSStyleSheetList::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    if (propertyName < static_cast<StyleSheetList*>(impl())->length()) {
        slot.setCustomIndex(this, propertyName, indexGetter);
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(propertyName), slot);
}

JSValue* JSStyleSheetList::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case LengthAttrNum: {
        StyleSheetList* imp = static_cast<StyleSheetList*>(impl());
        return jsNumber(imp->length());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSStyleSheetList::getPropertyNames(ExecState* exec, PropertyNameArray& propertyNames)
{
    for (unsigned i = 0; i < static_cast<StyleSheetList*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(i));
     Base::getPropertyNames(exec, propertyNames);
}

JSValue* JSStyleSheetList::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSStyleSheetListConstructor>(exec, "[[StyleSheetList.constructor]]");
}

JSValue* jsStyleSheetListPrototypeFunctionItem(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSStyleSheetList::info))
        return throwError(exec, TypeError);
    JSStyleSheetList* castedThisObj = static_cast<JSStyleSheetList*>(thisObj);
    StyleSheetList* imp = static_cast<StyleSheetList*>(castedThisObj->impl());
    unsigned index = args[0]->toInt32(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->item(index)));
    return result;
}


JSValue* JSStyleSheetList::indexGetter(ExecState* exec, JSObject* originalObject, const Identifier& propertyName, const PropertySlot& slot)
{
    JSStyleSheetList* thisObj = static_cast<JSStyleSheetList*>(slot.slotBase());
    return toJS(exec, static_cast<StyleSheetList*>(thisObj->impl())->item(slot.index()));
}
KJS::JSValue* toJS(KJS::ExecState* exec, StyleSheetList* obj)
{
    return cacheDOMObject<StyleSheetList, JSStyleSheetList, JSStyleSheetListPrototype>(exec, obj);
}
StyleSheetList* toStyleSheetList(KJS::JSValue* val)
{
    return val->isObject(&JSStyleSheetList::info) ? static_cast<JSStyleSheetList*>(val)->impl() : 0;
}

}
