/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSRangeException.h"

#include <wtf/GetPtr.h>

#include "KURL.h"
#include "RangeException.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSRangeExceptionTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "code", { (intptr_t)JSRangeException::CodeAttrNum }, DontDelete|ReadOnly, 0, &JSRangeExceptionTableEntries[8] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "message", { (intptr_t)JSRangeException::MessageAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "name", { (intptr_t)JSRangeException::NameAttrNum }, DontDelete|ReadOnly, 0, &JSRangeExceptionTableEntries[9] },
    { "constructor", { (intptr_t)JSRangeException::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSRangeExceptionTable = 
{
    3, 10, JSRangeExceptionTableEntries, 7
};

/* Hash table for constructor */

static const HashEntry JSRangeExceptionConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "BAD_BOUNDARYPOINTS_ERR", { (intptr_t)1 }, DontDelete|ReadOnly, 0, 0 },
    { "INVALID_NODE_TYPE_ERR", { (intptr_t)2 }, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSRangeExceptionConstructorTable = 
{
    3, 4, JSRangeExceptionConstructorTableEntries, 3
};

class JSRangeExceptionConstructor : public DOMObject {
public:
    JSRangeExceptionConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSRangeExceptionPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSRangeExceptionConstructor::info = { "RangeExceptionConstructor", 0, &JSRangeExceptionConstructorTable };

bool JSRangeExceptionConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSRangeExceptionConstructor, DOMObject>(exec, &JSRangeExceptionConstructorTable, this, propertyName, slot);
}

JSValue* JSRangeExceptionConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSRangeExceptionPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "BAD_BOUNDARYPOINTS_ERR", { (intptr_t)1 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "toString", { (intptr_t)jsRangeExceptionPrototypeFunctionToString }, DontDelete|DontEnum|Function, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "INVALID_NODE_TYPE_ERR", { (intptr_t)2 }, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSRangeExceptionPrototypeTable = 
{
    3, 8, JSRangeExceptionPrototypeTableEntries, 7
};

const ClassInfo JSRangeExceptionPrototype::info = { "RangeExceptionPrototype", 0, &JSRangeExceptionPrototypeTable };

JSObject* JSRangeExceptionPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSRangeExceptionPrototype>(exec, "[[JSRangeException.prototype]]");
}

bool JSRangeExceptionPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSRangeExceptionPrototype, JSObject>(exec, &JSRangeExceptionPrototypeTable, this, propertyName, slot);
}

JSValue* JSRangeExceptionPrototype::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

const ClassInfo JSRangeException::info = { "RangeException", 0, &JSRangeExceptionTable };

JSRangeException::JSRangeException(JSObject* prototype, RangeException* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSRangeException::~JSRangeException()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSRangeException::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSRangeException, Base>(exec, &JSRangeExceptionTable, this, propertyName, slot);
}

JSValue* JSRangeException::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case CodeAttrNum: {
        RangeException* imp = static_cast<RangeException*>(impl());
        return jsNumber(imp->code());
    }
    case NameAttrNum: {
        RangeException* imp = static_cast<RangeException*>(impl());
        return jsString(imp->name());
    }
    case MessageAttrNum: {
        RangeException* imp = static_cast<RangeException*>(impl());
        return jsString(imp->message());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSRangeException::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSRangeExceptionConstructor>(exec, "[[RangeException.constructor]]");
}

JSValue* jsRangeExceptionPrototypeFunctionToString(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSRangeException::info))
        return throwError(exec, TypeError);
    JSRangeException* castedThisObj = static_cast<JSRangeException*>(thisObj);
    RangeException* imp = static_cast<RangeException*>(castedThisObj->impl());


    KJS::JSValue* result = jsString(imp->toString());
    return result;
}

KJS::JSValue* toJS(KJS::ExecState* exec, RangeException* obj)
{
    return cacheDOMObject<RangeException, JSRangeException, JSRangeExceptionPrototype>(exec, obj);
}
RangeException* toRangeException(KJS::JSValue* val)
{
    return val->isObject(&JSRangeException::info) ? static_cast<JSRangeException*>(val)->impl() : 0;
}

}
