/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSProgressEvent.h"

#include <wtf/GetPtr.h>

#include "ProgressEvent.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSProgressEventTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "constructor", { (intptr_t)JSProgressEvent::ConstructorAttrNum }, DontEnum, 0, 0 },
    { "lengthComputable", { (intptr_t)JSProgressEvent::LengthComputableAttrNum }, DontDelete|ReadOnly, 0, &JSProgressEventTableEntries[8] },
    { "loaded", { (intptr_t)JSProgressEvent::LoadedAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "total", { (intptr_t)JSProgressEvent::TotalAttrNum }, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSProgressEventTable = 
{
    3, 9, JSProgressEventTableEntries, 7
};

/* Hash table for constructor */

static const HashEntry JSProgressEventConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSProgressEventConstructorTable = 
{
    3, 1, JSProgressEventConstructorTableEntries, 0
};

class JSProgressEventConstructor : public DOMObject {
public:
    JSProgressEventConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSProgressEventPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSProgressEventConstructor::info = { "ProgressEventConstructor", 0, &JSProgressEventConstructorTable };

bool JSProgressEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSProgressEventConstructor, DOMObject>(exec, &JSProgressEventConstructorTable, this, propertyName, slot);
}

JSValue* JSProgressEventConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSProgressEventPrototypeTableEntries[] =
{
    { "initProgressEvent", { (intptr_t)jsProgressEventPrototypeFunctionInitProgressEvent }, DontDelete|Function, 6, 0 },
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSProgressEventPrototypeTable = 
{
    3, 2, JSProgressEventPrototypeTableEntries, 1
};

const ClassInfo JSProgressEventPrototype::info = { "ProgressEventPrototype", 0, &JSProgressEventPrototypeTable };

JSObject* JSProgressEventPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSProgressEventPrototype>(exec, "[[JSProgressEvent.prototype]]");
}

bool JSProgressEventPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSProgressEventPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSProgressEvent::info = { "ProgressEvent", &JSEvent::info, &JSProgressEventTable };

JSProgressEvent::JSProgressEvent(JSObject* prototype, ProgressEvent* impl)
    : JSEvent(prototype, impl)
{
}

bool JSProgressEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSProgressEvent, Base>(exec, &JSProgressEventTable, this, propertyName, slot);
}

JSValue* JSProgressEvent::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case LengthComputableAttrNum: {
        ProgressEvent* imp = static_cast<ProgressEvent*>(impl());
        return jsBoolean(imp->lengthComputable());
    }
    case LoadedAttrNum: {
        ProgressEvent* imp = static_cast<ProgressEvent*>(impl());
        return jsNumber(imp->loaded());
    }
    case TotalAttrNum: {
        ProgressEvent* imp = static_cast<ProgressEvent*>(impl());
        return jsNumber(imp->total());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSProgressEvent::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSProgressEventConstructor>(exec, "[[ProgressEvent.constructor]]");
}

JSValue* jsProgressEventPrototypeFunctionInitProgressEvent(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSProgressEvent::info))
        return throwError(exec, TypeError);
    JSProgressEvent* castedThisObj = static_cast<JSProgressEvent*>(thisObj);
    ProgressEvent* imp = static_cast<ProgressEvent*>(castedThisObj->impl());
    String typeArg = args[0]->toString(exec);
    bool canBubbleArg = args[1]->toBoolean(exec);
    bool cancelableArg = args[2]->toBoolean(exec);
    bool lengthComputableArg = args[3]->toBoolean(exec);
    unsigned loadedArg = args[4]->toInt32(exec);
    unsigned totalArg = args[5]->toInt32(exec);

    imp->initProgressEvent(typeArg, canBubbleArg, cancelableArg, lengthComputableArg, loadedArg, totalArg);
    return jsUndefined();
}


}
