/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSOverflowEvent.h"

#include <wtf/GetPtr.h>

#include "OverflowEvent.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSOverflowEventTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "constructor", { (intptr_t)JSOverflowEvent::ConstructorAttrNum }, DontEnum, 0, 0 },
    { "verticalOverflow", { (intptr_t)JSOverflowEvent::VerticalOverflowAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "orient", { (intptr_t)JSOverflowEvent::OrientAttrNum }, DontDelete|ReadOnly, 0, &JSOverflowEventTableEntries[8] },
    { "horizontalOverflow", { (intptr_t)JSOverflowEvent::HorizontalOverflowAttrNum }, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSOverflowEventTable = 
{
    3, 9, JSOverflowEventTableEntries, 7
};

/* Hash table for constructor */

static const HashEntry JSOverflowEventConstructorTableEntries[] =
{
    { "HORIZONTAL", { (intptr_t)0 }, DontDelete|ReadOnly, 0, &JSOverflowEventConstructorTableEntries[8] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "VERTICAL", { (intptr_t)1 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "BOTH", { (intptr_t)2 }, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSOverflowEventConstructorTable = 
{
    3, 9, JSOverflowEventConstructorTableEntries, 7
};

class JSOverflowEventConstructor : public DOMObject {
public:
    JSOverflowEventConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSOverflowEventPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSOverflowEventConstructor::info = { "OverflowEventConstructor", 0, &JSOverflowEventConstructorTable };

bool JSOverflowEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSOverflowEventConstructor, DOMObject>(exec, &JSOverflowEventConstructorTable, this, propertyName, slot);
}

JSValue* JSOverflowEventConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSOverflowEventPrototypeTableEntries[] =
{
    { "HORIZONTAL", { (intptr_t)0 }, DontDelete|ReadOnly, 0, &JSOverflowEventPrototypeTableEntries[8] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "VERTICAL", { (intptr_t)1 }, DontDelete|ReadOnly, 0, 0 },
    { "initOverflowEvent", { (intptr_t)jsOverflowEventPrototypeFunctionInitOverflowEvent }, DontDelete|Function, 3, 0 },
    { "BOTH", { (intptr_t)2 }, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSOverflowEventPrototypeTable = 
{
    3, 9, JSOverflowEventPrototypeTableEntries, 7
};

const ClassInfo JSOverflowEventPrototype::info = { "OverflowEventPrototype", 0, &JSOverflowEventPrototypeTable };

JSObject* JSOverflowEventPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSOverflowEventPrototype>(exec, "[[JSOverflowEvent.prototype]]");
}

bool JSOverflowEventPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSOverflowEventPrototype, JSObject>(exec, &JSOverflowEventPrototypeTable, this, propertyName, slot);
}

JSValue* JSOverflowEventPrototype::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

const ClassInfo JSOverflowEvent::info = { "OverflowEvent", &JSEvent::info, &JSOverflowEventTable };

JSOverflowEvent::JSOverflowEvent(JSObject* prototype, OverflowEvent* impl)
    : JSEvent(prototype, impl)
{
}

bool JSOverflowEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSOverflowEvent, Base>(exec, &JSOverflowEventTable, this, propertyName, slot);
}

JSValue* JSOverflowEvent::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case OrientAttrNum: {
        OverflowEvent* imp = static_cast<OverflowEvent*>(impl());
        return jsNumber(imp->orient());
    }
    case HorizontalOverflowAttrNum: {
        OverflowEvent* imp = static_cast<OverflowEvent*>(impl());
        return jsBoolean(imp->horizontalOverflow());
    }
    case VerticalOverflowAttrNum: {
        OverflowEvent* imp = static_cast<OverflowEvent*>(impl());
        return jsBoolean(imp->verticalOverflow());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSOverflowEvent::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSOverflowEventConstructor>(exec, "[[OverflowEvent.constructor]]");
}

JSValue* jsOverflowEventPrototypeFunctionInitOverflowEvent(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSOverflowEvent::info))
        return throwError(exec, TypeError);
    JSOverflowEvent* castedThisObj = static_cast<JSOverflowEvent*>(thisObj);
    OverflowEvent* imp = static_cast<OverflowEvent*>(castedThisObj->impl());
    unsigned short orient = args[0]->toInt32(exec);
    bool horizontalOverflow = args[1]->toBoolean(exec);
    bool verticalOverflow = args[2]->toBoolean(exec);

    imp->initOverflowEvent(orient, horizontalOverflow, verticalOverflow);
    return jsUndefined();
}


}
