/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSNodeIterator.h"

#include <wtf/GetPtr.h>

#include "JSNode.h"
#include "JSNodeFilter.h"
#include "Node.h"
#include "NodeFilter.h"
#include "NodeIterator.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSNodeIteratorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "pointerBeforeReferenceNode", { (intptr_t)JSNodeIterator::PointerBeforeReferenceNodeAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "whatToShow", { (intptr_t)JSNodeIterator::WhatToShowAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "referenceNode", { (intptr_t)JSNodeIterator::ReferenceNodeAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "root", { (intptr_t)JSNodeIterator::RootAttrNum }, DontDelete|ReadOnly, 0, &JSNodeIteratorTableEntries[16] },
    { 0, { 0 }, 0, 0, 0 },
    { "filter", { (intptr_t)JSNodeIterator::FilterAttrNum }, DontDelete|ReadOnly, 0, &JSNodeIteratorTableEntries[17] },
    { "expandEntityReferences", { (intptr_t)JSNodeIterator::ExpandEntityReferencesAttrNum }, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSNodeIteratorTable = 
{
    3, 18, JSNodeIteratorTableEntries, 15
};

/* Hash table for prototype */

static const HashEntry JSNodeIteratorPrototypeTableEntries[] =
{
    { "nextNode", { (intptr_t)jsNodeIteratorPrototypeFunctionNextNode }, DontDelete|Function, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "previousNode", { (intptr_t)jsNodeIteratorPrototypeFunctionPreviousNode }, DontDelete|Function, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "detach", { (intptr_t)jsNodeIteratorPrototypeFunctionDetach }, DontDelete|Function, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSNodeIteratorPrototypeTable = 
{
    3, 8, JSNodeIteratorPrototypeTableEntries, 7
};

const ClassInfo JSNodeIteratorPrototype::info = { "NodeIteratorPrototype", 0, &JSNodeIteratorPrototypeTable };

JSObject* JSNodeIteratorPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSNodeIteratorPrototype>(exec, "[[JSNodeIterator.prototype]]");
}

bool JSNodeIteratorPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSNodeIteratorPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSNodeIterator::info = { "NodeIterator", 0, &JSNodeIteratorTable };

JSNodeIterator::JSNodeIterator(JSObject* prototype, NodeIterator* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSNodeIterator::~JSNodeIterator()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSNodeIterator::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSNodeIterator, Base>(exec, &JSNodeIteratorTable, this, propertyName, slot);
}

JSValue* JSNodeIterator::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case RootAttrNum: {
        NodeIterator* imp = static_cast<NodeIterator*>(impl());
        return toJS(exec, WTF::getPtr(imp->root()));
    }
    case WhatToShowAttrNum: {
        NodeIterator* imp = static_cast<NodeIterator*>(impl());
        return jsNumber(imp->whatToShow());
    }
    case FilterAttrNum: {
        NodeIterator* imp = static_cast<NodeIterator*>(impl());
        return toJS(exec, WTF::getPtr(imp->filter()));
    }
    case ExpandEntityReferencesAttrNum: {
        NodeIterator* imp = static_cast<NodeIterator*>(impl());
        return jsBoolean(imp->expandEntityReferences());
    }
    case ReferenceNodeAttrNum: {
        NodeIterator* imp = static_cast<NodeIterator*>(impl());
        return toJS(exec, WTF::getPtr(imp->referenceNode()));
    }
    case PointerBeforeReferenceNodeAttrNum: {
        NodeIterator* imp = static_cast<NodeIterator*>(impl());
        return jsBoolean(imp->pointerBeforeReferenceNode());
    }
    }
    return 0;
}

JSValue* jsNodeIteratorPrototypeFunctionNextNode(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSNodeIterator::info))
        return throwError(exec, TypeError);
    JSNodeIterator* castedThisObj = static_cast<JSNodeIterator*>(thisObj);
    return castedThisObj->nextNode(exec, args);
}

JSValue* jsNodeIteratorPrototypeFunctionPreviousNode(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSNodeIterator::info))
        return throwError(exec, TypeError);
    JSNodeIterator* castedThisObj = static_cast<JSNodeIterator*>(thisObj);
    return castedThisObj->previousNode(exec, args);
}

JSValue* jsNodeIteratorPrototypeFunctionDetach(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSNodeIterator::info))
        return throwError(exec, TypeError);
    JSNodeIterator* castedThisObj = static_cast<JSNodeIterator*>(thisObj);
    NodeIterator* imp = static_cast<NodeIterator*>(castedThisObj->impl());

    imp->detach();
    return jsUndefined();
}

KJS::JSValue* toJS(KJS::ExecState* exec, NodeIterator* obj)
{
    return cacheDOMObject<NodeIterator, JSNodeIterator, JSNodeIteratorPrototype>(exec, obj);
}
NodeIterator* toNodeIterator(KJS::JSValue* val)
{
    return val->isObject(&JSNodeIterator::info) ? static_cast<JSNodeIterator*>(val)->impl() : 0;
}

}
