/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSNodeFilter.h"

#include <wtf/GetPtr.h>

#include "NodeFilter.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSNodeFilterTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "constructor", { (intptr_t)JSNodeFilter::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSNodeFilterTable = 
{
    3, 2, JSNodeFilterTableEntries, 1
};

/* Hash table for constructor */

static const HashEntry JSNodeFilterConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "FILTER_REJECT", { (intptr_t)2 }, DontDelete|ReadOnly, 0, 0 },
    { "SHOW_TEXT", { (intptr_t)0x00000004 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "SHOW_DOCUMENT_FRAGMENT", { (intptr_t)0x00000400 }, DontDelete|ReadOnly, 0, 0 },
    { "SHOW_ENTITY_REFERENCE", { (intptr_t)0x00000010 }, DontDelete|ReadOnly, 0, 0 },
    { "SHOW_NOTATION", { (intptr_t)0x00000800 }, DontDelete|ReadOnly, 0, 0 },
    { "SHOW_PROCESSING_INSTRUCTION", { (intptr_t)0x00000040 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "SHOW_DOCUMENT", { (intptr_t)0x00000100 }, DontDelete|ReadOnly, 0, 0 },
    { "FILTER_SKIP", { (intptr_t)3 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "SHOW_CDATA_SECTION", { (intptr_t)0x00000008 }, DontDelete|ReadOnly, 0, &JSNodeFilterConstructorTableEntries[33] },
    { "FILTER_ACCEPT", { (intptr_t)1 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "SHOW_ELEMENT", { (intptr_t)0x00000001 }, DontDelete|ReadOnly, 0, &JSNodeFilterConstructorTableEntries[32] },
    { "SHOW_DOCUMENT_TYPE", { (intptr_t)0x00000200 }, DontDelete|ReadOnly, 0, 0 },
    { "SHOW_COMMENT", { (intptr_t)0x00000080 }, DontDelete|ReadOnly, 0, 0 },
    { "SHOW_ALL", { (intptr_t)0xFFFFFFFF }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "SHOW_ATTRIBUTE", { (intptr_t)0x00000002 }, DontDelete|ReadOnly, 0, 0 },
    { "SHOW_ENTITY", { (intptr_t)0x00000020 }, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSNodeFilterConstructorTable = 
{
    3, 34, JSNodeFilterConstructorTableEntries, 31
};

class JSNodeFilterConstructor : public DOMObject {
public:
    JSNodeFilterConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSNodeFilterPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSNodeFilterConstructor::info = { "NodeFilterConstructor", 0, &JSNodeFilterConstructorTable };

bool JSNodeFilterConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSNodeFilterConstructor, DOMObject>(exec, &JSNodeFilterConstructorTable, this, propertyName, slot);
}

JSValue* JSNodeFilterConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSNodeFilterPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "FILTER_REJECT", { (intptr_t)2 }, DontDelete|ReadOnly, 0, 0 },
    { "SHOW_TEXT", { (intptr_t)0x00000004 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "SHOW_DOCUMENT_FRAGMENT", { (intptr_t)0x00000400 }, DontDelete|ReadOnly, 0, 0 },
    { "SHOW_ENTITY_REFERENCE", { (intptr_t)0x00000010 }, DontDelete|ReadOnly, 0, 0 },
    { "SHOW_NOTATION", { (intptr_t)0x00000800 }, DontDelete|ReadOnly, 0, 0 },
    { "SHOW_PROCESSING_INSTRUCTION", { (intptr_t)0x00000040 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "SHOW_DOCUMENT", { (intptr_t)0x00000100 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "SHOW_ELEMENT", { (intptr_t)0x00000001 }, DontDelete|ReadOnly, 0, 0 },
    { "SHOW_DOCUMENT_TYPE", { (intptr_t)0x00000200 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "FILTER_SKIP", { (intptr_t)3 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "SHOW_CDATA_SECTION", { (intptr_t)0x00000008 }, DontDelete|ReadOnly, 0, &JSNodeFilterPrototypeTableEntries[64] },
    { "FILTER_ACCEPT", { (intptr_t)1 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "SHOW_ATTRIBUTE", { (intptr_t)0x00000002 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "SHOW_COMMENT", { (intptr_t)0x00000080 }, DontDelete|ReadOnly, 0, 0 },
    { "SHOW_ALL", { (intptr_t)0xFFFFFFFF }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "SHOW_ENTITY", { (intptr_t)0x00000020 }, DontDelete|ReadOnly, 0, &JSNodeFilterPrototypeTableEntries[65] },
    { "acceptNode", { (intptr_t)jsNodeFilterPrototypeFunctionAcceptNode }, DontDelete|Function, 1, 0 }
};

static const HashTable JSNodeFilterPrototypeTable = 
{
    3, 66, JSNodeFilterPrototypeTableEntries, 63
};

const ClassInfo JSNodeFilterPrototype::info = { "NodeFilterPrototype", 0, &JSNodeFilterPrototypeTable };

JSObject* JSNodeFilterPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSNodeFilterPrototype>(exec, "[[JSNodeFilter.prototype]]");
}

bool JSNodeFilterPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSNodeFilterPrototype, JSObject>(exec, &JSNodeFilterPrototypeTable, this, propertyName, slot);
}

JSValue* JSNodeFilterPrototype::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

const ClassInfo JSNodeFilter::info = { "NodeFilter", 0, &JSNodeFilterTable };

JSNodeFilter::JSNodeFilter(JSObject* prototype, NodeFilter* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSNodeFilter::~JSNodeFilter()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSNodeFilter::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSNodeFilter, Base>(exec, &JSNodeFilterTable, this, propertyName, slot);
}

JSValue* JSNodeFilter::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSNodeFilter::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSNodeFilterConstructor>(exec, "[[NodeFilter.constructor]]");
}

JSValue* jsNodeFilterPrototypeFunctionAcceptNode(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSNodeFilter::info))
        return throwError(exec, TypeError);
    JSNodeFilter* castedThisObj = static_cast<JSNodeFilter*>(thisObj);
    return castedThisObj->acceptNode(exec, args);
}

KJS::JSValue* toJS(KJS::ExecState* exec, NodeFilter* obj)
{
    return cacheDOMObject<NodeFilter, JSNodeFilter, JSNodeFilterPrototype>(exec, obj);
}

}
