/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSNode.h"

#include <wtf/GetPtr.h>

#include "Document.h"
#include "JSDocument.h"
#include "JSNamedNodeMap.h"
#include "JSNode.h"
#include "JSNodeList.h"
#include "KURL.h"
#include "NameNodeList.h"
#include "NamedAttrMap.h"
#include "NamedNodeMap.h"
#include "Node.h"
#include "NodeList.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSNodeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "previousSibling", { (intptr_t)JSNode::PreviousSiblingAttrNum }, DontDelete|ReadOnly, 0, &JSNodeTableEntries[66] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "parentNode", { (intptr_t)JSNode::ParentNodeAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "lastChild", { (intptr_t)JSNode::LastChildAttrNum }, DontDelete|ReadOnly, 0, &JSNodeTableEntries[67] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "constructor", { (intptr_t)JSNode::ConstructorAttrNum }, DontEnum, 0, 0 },
    { "baseURI", { (intptr_t)JSNode::BaseURIAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "firstChild", { (intptr_t)JSNode::FirstChildAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "nodeValue", { (intptr_t)JSNode::NodeValueAttrNum }, DontDelete, 0, &JSNodeTableEntries[65] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "textContent", { (intptr_t)JSNode::TextContentAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "nodeType", { (intptr_t)JSNode::NodeTypeAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "nodeName", { (intptr_t)JSNode::NodeNameAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "prefix", { (intptr_t)JSNode::PrefixAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "childNodes", { (intptr_t)JSNode::ChildNodesAttrNum }, DontDelete|ReadOnly, 0, &JSNodeTableEntries[64] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "nextSibling", { (intptr_t)JSNode::NextSiblingAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "attributes", { (intptr_t)JSNode::AttributesAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "ownerDocument", { (intptr_t)JSNode::OwnerDocumentAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "namespaceURI", { (intptr_t)JSNode::NamespaceURIAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "localName", { (intptr_t)JSNode::LocalNameAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "parentElement", { (intptr_t)JSNode::ParentElementAttrNum }, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSNodeTable = 
{
    3, 68, JSNodeTableEntries, 63
};

/* Hash table for constructor */

static const HashEntry JSNodeConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "ENTITY_NODE", { (intptr_t)6 }, DontDelete|ReadOnly, 0, 0 },
    { "TEXT_NODE", { (intptr_t)3 }, DontDelete|ReadOnly, 0, 0 },
    { "ENTITY_REFERENCE_NODE", { (intptr_t)5 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "DOCUMENT_TYPE_NODE", { (intptr_t)10 }, DontDelete|ReadOnly, 0, 0 },
    { "COMMENT_NODE", { (intptr_t)8 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "NOTATION_NODE", { (intptr_t)12 }, DontDelete|ReadOnly, 0, 0 },
    { "CDATA_SECTION_NODE", { (intptr_t)4 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "DOCUMENT_FRAGMENT_NODE", { (intptr_t)11 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "ELEMENT_NODE", { (intptr_t)1 }, DontDelete|ReadOnly, 0, 0 },
    { "ATTRIBUTE_NODE", { (intptr_t)2 }, DontDelete|ReadOnly, 0, &JSNodeConstructorTableEntries[32] },
    { 0, { 0 }, 0, 0, 0 },
    { "PROCESSING_INSTRUCTION_NODE", { (intptr_t)7 }, DontDelete|ReadOnly, 0, &JSNodeConstructorTableEntries[33] },
    { "DOCUMENT_NODE", { (intptr_t)9 }, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSNodeConstructorTable = 
{
    3, 34, JSNodeConstructorTableEntries, 31
};

class JSNodeConstructor : public DOMObject {
public:
    JSNodeConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSNodePrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSNodeConstructor::info = { "NodeConstructor", 0, &JSNodeConstructorTable };

bool JSNodeConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSNodeConstructor, DOMObject>(exec, &JSNodeConstructorTable, this, propertyName, slot);
}

JSValue* JSNodeConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSNodePrototypeTableEntries[] =
{
    { "insertBefore", { (intptr_t)jsNodePrototypeFunctionInsertBefore }, DontDelete|Function, 2, &JSNodePrototypeTableEntries[68] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "hasAttributes", { (intptr_t)jsNodePrototypeFunctionHasAttributes }, DontDelete|Function, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "removeChild", { (intptr_t)jsNodePrototypeFunctionRemoveChild }, DontDelete|Function, 1, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "NOTATION_NODE", { (intptr_t)12 }, DontDelete|ReadOnly, 0, 0 },
    { "CDATA_SECTION_NODE", { (intptr_t)4 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "hasChildNodes", { (intptr_t)jsNodePrototypeFunctionHasChildNodes }, DontDelete|Function, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "isSupported", { (intptr_t)jsNodePrototypeFunctionIsSupported }, DontDelete|Function, 2, 0 },
    { "ELEMENT_NODE", { (intptr_t)1 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "normalize", { (intptr_t)jsNodePrototypeFunctionNormalize }, DontDelete|Function, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "isEqualNode", { (intptr_t)jsNodePrototypeFunctionIsEqualNode }, DontDelete|Function, 1, 0 },
    { "ENTITY_NODE", { (intptr_t)6 }, DontDelete|ReadOnly, 0, &JSNodePrototypeTableEntries[66] },
    { "TEXT_NODE", { (intptr_t)3 }, DontDelete|ReadOnly, 0, 0 },
    { "ENTITY_REFERENCE_NODE", { (intptr_t)5 }, DontDelete|ReadOnly, 0, &JSNodePrototypeTableEntries[67] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "DOCUMENT_TYPE_NODE", { (intptr_t)10 }, DontDelete|ReadOnly, 0, 0 },
    { "COMMENT_NODE", { (intptr_t)8 }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "replaceChild", { (intptr_t)jsNodePrototypeFunctionReplaceChild }, DontDelete|Function, 2, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "DOCUMENT_FRAGMENT_NODE", { (intptr_t)11 }, DontDelete|ReadOnly, 0, 0 },
    { "cloneNode", { (intptr_t)jsNodePrototypeFunctionCloneNode }, DontDelete|Function, 1, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "ATTRIBUTE_NODE", { (intptr_t)2 }, DontDelete|ReadOnly, 0, &JSNodePrototypeTableEntries[64] },
    { "isDefaultNamespace", { (intptr_t)jsNodePrototypeFunctionIsDefaultNamespace }, DontDelete|Function, 1, &JSNodePrototypeTableEntries[69] },
    { "PROCESSING_INSTRUCTION_NODE", { (intptr_t)7 }, DontDelete|ReadOnly, 0, &JSNodePrototypeTableEntries[65] },
    { "DOCUMENT_NODE", { (intptr_t)9 }, DontDelete|ReadOnly, 0, 0 },
    { "appendChild", { (intptr_t)jsNodePrototypeFunctionAppendChild }, DontDelete|Function, 1, 0 },
    { "isSameNode", { (intptr_t)jsNodePrototypeFunctionIsSameNode }, DontDelete|Function, 1, 0 },
    { "lookupPrefix", { (intptr_t)jsNodePrototypeFunctionLookupPrefix }, DontDelete|Function, 1, 0 },
    { "lookupNamespaceURI", { (intptr_t)jsNodePrototypeFunctionLookupNamespaceURI }, DontDelete|Function, 1, 0 }
};

static const HashTable JSNodePrototypeTable = 
{
    3, 70, JSNodePrototypeTableEntries, 63
};

const ClassInfo JSNodePrototype::info = { "NodePrototype", 0, &JSNodePrototypeTable };

JSObject* JSNodePrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSNodePrototype>(exec, "[[JSNode.prototype]]");
}

bool JSNodePrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSNodePrototype, JSObject>(exec, &JSNodePrototypeTable, this, propertyName, slot);
}

JSValue* JSNodePrototype::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

const ClassInfo JSNode::info = { "Node", 0, &JSNodeTable };

JSNode::JSNode(JSObject* prototype, Node* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSNode::~JSNode()
{
    ScriptInterpreter::forgetDOMNodeForDocument(m_impl->document(), m_impl.get());

}

bool JSNode::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSNode, Base>(exec, &JSNodeTable, this, propertyName, slot);
}

JSValue* JSNode::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case NodeNameAttrNum: {
        Node* imp = static_cast<Node*>(impl());
        return jsStringOrNull(imp->nodeName());
    }
    case NodeValueAttrNum: {
        Node* imp = static_cast<Node*>(impl());
        return jsStringOrNull(imp->nodeValue());
    }
    case NodeTypeAttrNum: {
        Node* imp = static_cast<Node*>(impl());
        return jsNumber(imp->nodeType());
    }
    case ParentNodeAttrNum: {
        Node* imp = static_cast<Node*>(impl());
        return toJS(exec, WTF::getPtr(imp->parentNode()));
    }
    case ChildNodesAttrNum: {
        Node* imp = static_cast<Node*>(impl());
        return toJS(exec, WTF::getPtr(imp->childNodes()));
    }
    case FirstChildAttrNum: {
        Node* imp = static_cast<Node*>(impl());
        return toJS(exec, WTF::getPtr(imp->firstChild()));
    }
    case LastChildAttrNum: {
        Node* imp = static_cast<Node*>(impl());
        return toJS(exec, WTF::getPtr(imp->lastChild()));
    }
    case PreviousSiblingAttrNum: {
        Node* imp = static_cast<Node*>(impl());
        return toJS(exec, WTF::getPtr(imp->previousSibling()));
    }
    case NextSiblingAttrNum: {
        Node* imp = static_cast<Node*>(impl());
        return toJS(exec, WTF::getPtr(imp->nextSibling()));
    }
    case AttributesAttrNum: {
        Node* imp = static_cast<Node*>(impl());
        return toJS(exec, WTF::getPtr(imp->attributes()));
    }
    case OwnerDocumentAttrNum: {
        Node* imp = static_cast<Node*>(impl());
        return toJS(exec, WTF::getPtr(imp->ownerDocument()));
    }
    case NamespaceURIAttrNum: {
        Node* imp = static_cast<Node*>(impl());
        return jsStringOrNull(imp->namespaceURI());
    }
    case PrefixAttrNum: {
        Node* imp = static_cast<Node*>(impl());
        return jsStringOrNull(imp->prefix());
    }
    case LocalNameAttrNum: {
        Node* imp = static_cast<Node*>(impl());
        return jsStringOrNull(imp->localName());
    }
    case BaseURIAttrNum: {
        Node* imp = static_cast<Node*>(impl());
        return jsStringOrNull(imp->baseURI());
    }
    case TextContentAttrNum: {
        Node* imp = static_cast<Node*>(impl());
        return jsStringOrNull(imp->textContent());
    }
    case ParentElementAttrNum: {
        Node* imp = static_cast<Node*>(impl());
        return toJS(exec, WTF::getPtr(imp->parentElement()));
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSNode::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSNode, Base>(exec, propertyName, value, &JSNodeTable, this);
}

void JSNode::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case NodeValueAttrNum: {
        Node* imp = static_cast<Node*>(impl());
        ExceptionCode ec = 0;
        imp->setNodeValue(valueToStringWithNullCheck(exec, value), ec);
        setDOMException(exec, ec);
        break;
    }
    case PrefixAttrNum: {
        Node* imp = static_cast<Node*>(impl());
        ExceptionCode ec = 0;
        imp->setPrefix(valueToStringWithNullCheck(exec, value), ec);
        setDOMException(exec, ec);
        break;
    }
    case TextContentAttrNum: {
        Node* imp = static_cast<Node*>(impl());
        ExceptionCode ec = 0;
        imp->setTextContent(valueToStringWithNullCheck(exec, value), ec);
        setDOMException(exec, ec);
        break;
    }
    }
}

JSValue* JSNode::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSNodeConstructor>(exec, "[[Node.constructor]]");
}

JSValue* jsNodePrototypeFunctionInsertBefore(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSNode::info))
        return throwError(exec, TypeError);
    JSNode* castedThisObj = static_cast<JSNode*>(thisObj);
    return castedThisObj->insertBefore(exec, args);
}

JSValue* jsNodePrototypeFunctionReplaceChild(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSNode::info))
        return throwError(exec, TypeError);
    JSNode* castedThisObj = static_cast<JSNode*>(thisObj);
    return castedThisObj->replaceChild(exec, args);
}

JSValue* jsNodePrototypeFunctionRemoveChild(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSNode::info))
        return throwError(exec, TypeError);
    JSNode* castedThisObj = static_cast<JSNode*>(thisObj);
    return castedThisObj->removeChild(exec, args);
}

JSValue* jsNodePrototypeFunctionAppendChild(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSNode::info))
        return throwError(exec, TypeError);
    JSNode* castedThisObj = static_cast<JSNode*>(thisObj);
    return castedThisObj->appendChild(exec, args);
}

JSValue* jsNodePrototypeFunctionHasChildNodes(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSNode::info))
        return throwError(exec, TypeError);
    JSNode* castedThisObj = static_cast<JSNode*>(thisObj);
    Node* imp = static_cast<Node*>(castedThisObj->impl());


    KJS::JSValue* result = jsBoolean(imp->hasChildNodes());
    return result;
}

JSValue* jsNodePrototypeFunctionCloneNode(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSNode::info))
        return throwError(exec, TypeError);
    JSNode* castedThisObj = static_cast<JSNode*>(thisObj);
    Node* imp = static_cast<Node*>(castedThisObj->impl());
    bool deep = args[0]->toBoolean(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->cloneNode(deep)));
    return result;
}

JSValue* jsNodePrototypeFunctionNormalize(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSNode::info))
        return throwError(exec, TypeError);
    JSNode* castedThisObj = static_cast<JSNode*>(thisObj);
    Node* imp = static_cast<Node*>(castedThisObj->impl());

    imp->normalize();
    return jsUndefined();
}

JSValue* jsNodePrototypeFunctionIsSupported(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSNode::info))
        return throwError(exec, TypeError);
    JSNode* castedThisObj = static_cast<JSNode*>(thisObj);
    Node* imp = static_cast<Node*>(castedThisObj->impl());
    String feature = args[0]->toString(exec);
    String version = valueToStringWithNullCheck(exec, args[1]);


    KJS::JSValue* result = jsBoolean(imp->isSupported(feature, version));
    return result;
}

JSValue* jsNodePrototypeFunctionHasAttributes(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSNode::info))
        return throwError(exec, TypeError);
    JSNode* castedThisObj = static_cast<JSNode*>(thisObj);
    Node* imp = static_cast<Node*>(castedThisObj->impl());


    KJS::JSValue* result = jsBoolean(imp->hasAttributes());
    return result;
}

JSValue* jsNodePrototypeFunctionIsSameNode(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSNode::info))
        return throwError(exec, TypeError);
    JSNode* castedThisObj = static_cast<JSNode*>(thisObj);
    Node* imp = static_cast<Node*>(castedThisObj->impl());
    Node* other = toNode(args[0]);


    KJS::JSValue* result = jsBoolean(imp->isSameNode(other));
    return result;
}

JSValue* jsNodePrototypeFunctionIsEqualNode(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSNode::info))
        return throwError(exec, TypeError);
    JSNode* castedThisObj = static_cast<JSNode*>(thisObj);
    Node* imp = static_cast<Node*>(castedThisObj->impl());
    Node* other = toNode(args[0]);


    KJS::JSValue* result = jsBoolean(imp->isEqualNode(other));
    return result;
}

JSValue* jsNodePrototypeFunctionLookupPrefix(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSNode::info))
        return throwError(exec, TypeError);
    JSNode* castedThisObj = static_cast<JSNode*>(thisObj);
    Node* imp = static_cast<Node*>(castedThisObj->impl());
    String namespaceURI = valueToStringWithNullCheck(exec, args[0]);


    KJS::JSValue* result = jsStringOrNull(imp->lookupPrefix(namespaceURI));
    return result;
}

JSValue* jsNodePrototypeFunctionIsDefaultNamespace(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSNode::info))
        return throwError(exec, TypeError);
    JSNode* castedThisObj = static_cast<JSNode*>(thisObj);
    Node* imp = static_cast<Node*>(castedThisObj->impl());
    String namespaceURI = valueToStringWithNullCheck(exec, args[0]);


    KJS::JSValue* result = jsBoolean(imp->isDefaultNamespace(namespaceURI));
    return result;
}

JSValue* jsNodePrototypeFunctionLookupNamespaceURI(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSNode::info))
        return throwError(exec, TypeError);
    JSNode* castedThisObj = static_cast<JSNode*>(thisObj);
    Node* imp = static_cast<Node*>(castedThisObj->impl());
    String prefix = valueToStringWithNullCheck(exec, args[0]);


    KJS::JSValue* result = jsStringOrNull(imp->lookupNamespaceURI(prefix));
    return result;
}

Node* toNode(KJS::JSValue* val)
{
    return val->isObject(&JSNode::info) ? static_cast<JSNode*>(val)->impl() : 0;
}

}
