/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSNamedNodeMap.h"

#include <wtf/GetPtr.h>

#include <kjs/PropertyNameArray.h>
#include "AtomicString.h"
#include "JSNode.h"
#include "NamedNodeMap.h"
#include "Node.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSNamedNodeMapTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "length", { (intptr_t)JSNamedNodeMap::LengthAttrNum }, DontDelete|ReadOnly, 0, &JSNamedNodeMapTableEntries[4] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "constructor", { (intptr_t)JSNamedNodeMap::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSNamedNodeMapTable = 
{
    3, 5, JSNamedNodeMapTableEntries, 3
};

/* Hash table for constructor */

static const HashEntry JSNamedNodeMapConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSNamedNodeMapConstructorTable = 
{
    3, 1, JSNamedNodeMapConstructorTableEntries, 0
};

class JSNamedNodeMapConstructor : public DOMObject {
public:
    JSNamedNodeMapConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSNamedNodeMapPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSNamedNodeMapConstructor::info = { "NamedNodeMapConstructor", 0, &JSNamedNodeMapConstructorTable };

bool JSNamedNodeMapConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSNamedNodeMapConstructor, DOMObject>(exec, &JSNamedNodeMapConstructorTable, this, propertyName, slot);
}

JSValue* JSNamedNodeMapConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSNamedNodeMapPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "removeNamedItemNS", { (intptr_t)jsNamedNodeMapPrototypeFunctionRemoveNamedItemNS }, DontDelete|Function, 2, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "getNamedItem", { (intptr_t)jsNamedNodeMapPrototypeFunctionGetNamedItem }, DontDelete|Function, 1, 0 },
    { "removeNamedItem", { (intptr_t)jsNamedNodeMapPrototypeFunctionRemoveNamedItem }, DontDelete|Function, 1, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "getNamedItemNS", { (intptr_t)jsNamedNodeMapPrototypeFunctionGetNamedItemNS }, DontDelete|Function, 2, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "setNamedItemNS", { (intptr_t)jsNamedNodeMapPrototypeFunctionSetNamedItemNS }, DontDelete|Function, 1, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "setNamedItem", { (intptr_t)jsNamedNodeMapPrototypeFunctionSetNamedItem }, DontDelete|Function, 1, 0 },
    { "item", { (intptr_t)jsNamedNodeMapPrototypeFunctionItem }, DontDelete|Function, 1, 0 }
};

static const HashTable JSNamedNodeMapPrototypeTable = 
{
    3, 16, JSNamedNodeMapPrototypeTableEntries, 15
};

const ClassInfo JSNamedNodeMapPrototype::info = { "NamedNodeMapPrototype", 0, &JSNamedNodeMapPrototypeTable };

JSObject* JSNamedNodeMapPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSNamedNodeMapPrototype>(exec, "[[JSNamedNodeMap.prototype]]");
}

bool JSNamedNodeMapPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSNamedNodeMapPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSNamedNodeMap::info = { "NamedNodeMap", 0, &JSNamedNodeMapTable };

JSNamedNodeMap::JSNamedNodeMap(JSObject* prototype, NamedNodeMap* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSNamedNodeMap::~JSNamedNodeMap()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSNamedNodeMap::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    JSValue* proto = prototype();
    if (proto->isObject() && static_cast<JSObject*>(proto)->hasProperty(exec, propertyName))
        return false;

    const HashEntry* entry = Lookup::findEntry(&JSNamedNodeMapTable, propertyName);
    if (entry) {
        slot.setStaticEntry(this, entry, staticValueGetter<JSNamedNodeMap>);
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<NamedNodeMap*>(impl())->length()) {
        slot.setCustomIndex(this, index, indexGetter);
        return true;
    }
    if (canGetItemsForName(exec, static_cast<NamedNodeMap*>(impl()), propertyName)) {
        slot.setCustom(this, nameGetter);
        return true;
    }
    return getStaticValueSlot<JSNamedNodeMap, Base>(exec, &JSNamedNodeMapTable, this, propertyName, slot);
}

bool JSNamedNodeMap::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    if (propertyName < static_cast<NamedNodeMap*>(impl())->length()) {
        slot.setCustomIndex(this, propertyName, indexGetter);
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(propertyName), slot);
}

JSValue* JSNamedNodeMap::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case LengthAttrNum: {
        NamedNodeMap* imp = static_cast<NamedNodeMap*>(impl());
        return jsNumber(imp->length());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSNamedNodeMap::getPropertyNames(ExecState* exec, PropertyNameArray& propertyNames)
{
    for (unsigned i = 0; i < static_cast<NamedNodeMap*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(i));
     Base::getPropertyNames(exec, propertyNames);
}

JSValue* JSNamedNodeMap::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSNamedNodeMapConstructor>(exec, "[[NamedNodeMap.constructor]]");
}

JSValue* jsNamedNodeMapPrototypeFunctionGetNamedItem(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSNamedNodeMap::info))
        return throwError(exec, TypeError);
    JSNamedNodeMap* castedThisObj = static_cast<JSNamedNodeMap*>(thisObj);
    NamedNodeMap* imp = static_cast<NamedNodeMap*>(castedThisObj->impl());
    String name = args[0]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getNamedItem(name)));
    return result;
}

JSValue* jsNamedNodeMapPrototypeFunctionSetNamedItem(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSNamedNodeMap::info))
        return throwError(exec, TypeError);
    JSNamedNodeMap* castedThisObj = static_cast<JSNamedNodeMap*>(thisObj);
    NamedNodeMap* imp = static_cast<NamedNodeMap*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* node = toNode(args[0]);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->setNamedItem(node, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsNamedNodeMapPrototypeFunctionRemoveNamedItem(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSNamedNodeMap::info))
        return throwError(exec, TypeError);
    JSNamedNodeMap* castedThisObj = static_cast<JSNamedNodeMap*>(thisObj);
    NamedNodeMap* imp = static_cast<NamedNodeMap*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    String name = args[0]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->removeNamedItem(name, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsNamedNodeMapPrototypeFunctionItem(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSNamedNodeMap::info))
        return throwError(exec, TypeError);
    JSNamedNodeMap* castedThisObj = static_cast<JSNamedNodeMap*>(thisObj);
    NamedNodeMap* imp = static_cast<NamedNodeMap*>(castedThisObj->impl());
    unsigned index = args[0]->toInt32(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->item(index)));
    return result;
}

JSValue* jsNamedNodeMapPrototypeFunctionGetNamedItemNS(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSNamedNodeMap::info))
        return throwError(exec, TypeError);
    JSNamedNodeMap* castedThisObj = static_cast<JSNamedNodeMap*>(thisObj);
    NamedNodeMap* imp = static_cast<NamedNodeMap*>(castedThisObj->impl());
    String namespaceURI = valueToStringWithNullCheck(exec, args[0]);
    String localName = args[1]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->getNamedItemNS(namespaceURI, localName)));
    return result;
}

JSValue* jsNamedNodeMapPrototypeFunctionSetNamedItemNS(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSNamedNodeMap::info))
        return throwError(exec, TypeError);
    JSNamedNodeMap* castedThisObj = static_cast<JSNamedNodeMap*>(thisObj);
    NamedNodeMap* imp = static_cast<NamedNodeMap*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Node* node = toNode(args[0]);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->setNamedItemNS(node, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsNamedNodeMapPrototypeFunctionRemoveNamedItemNS(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSNamedNodeMap::info))
        return throwError(exec, TypeError);
    JSNamedNodeMap* castedThisObj = static_cast<JSNamedNodeMap*>(thisObj);
    NamedNodeMap* imp = static_cast<NamedNodeMap*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    String namespaceURI = valueToStringWithNullCheck(exec, args[0]);
    String localName = args[1]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->removeNamedItemNS(namespaceURI, localName, ec)));
    setDOMException(exec, ec);
    return result;
}


JSValue* JSNamedNodeMap::indexGetter(ExecState* exec, JSObject* originalObject, const Identifier& propertyName, const PropertySlot& slot)
{
    JSNamedNodeMap* thisObj = static_cast<JSNamedNodeMap*>(slot.slotBase());
    return toJS(exec, static_cast<NamedNodeMap*>(thisObj->impl())->item(slot.index()));
}
KJS::JSValue* toJS(KJS::ExecState* exec, NamedNodeMap* obj)
{
    return cacheDOMObject<NamedNodeMap, JSNamedNodeMap, JSNamedNodeMapPrototype>(exec, obj);
}
NamedNodeMap* toNamedNodeMap(KJS::JSValue* val)
{
    return val->isObject(&JSNamedNodeMap::info) ? static_cast<JSNamedNodeMap*>(val)->impl() : 0;
}

}
