/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSMouseEvent.h"

#include <wtf/GetPtr.h>

#include "Clipboard.h"
#include "EventTargetNode.h"
#include "JSClipboard.h"
#include "JSDOMWindow.h"
#include "JSEventTargetNode.h"
#include "JSNode.h"
#include "MouseEvent.h"
#include "Node.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSMouseEventTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "shiftKey", { (intptr_t)JSMouseEvent::ShiftKeyAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "toElement", { (intptr_t)JSMouseEvent::ToElementAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "clientY", { (intptr_t)JSMouseEvent::ClientYAttrNum }, DontDelete|ReadOnly, 0, &JSMouseEventTableEntries[64] },
    { "y", { (intptr_t)JSMouseEvent::YAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "x", { (intptr_t)JSMouseEvent::XAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "ctrlKey", { (intptr_t)JSMouseEvent::CtrlKeyAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "relatedTarget", { (intptr_t)JSMouseEvent::RelatedTargetAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "constructor", { (intptr_t)JSMouseEvent::ConstructorAttrNum }, DontEnum, 0, 0 },
    { "clientX", { (intptr_t)JSMouseEvent::ClientXAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "screenY", { (intptr_t)JSMouseEvent::ScreenYAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "metaKey", { (intptr_t)JSMouseEvent::MetaKeyAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "offsetX", { (intptr_t)JSMouseEvent::OffsetXAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "altKey", { (intptr_t)JSMouseEvent::AltKeyAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "offsetY", { (intptr_t)JSMouseEvent::OffsetYAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "fromElement", { (intptr_t)JSMouseEvent::FromElementAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "screenX", { (intptr_t)JSMouseEvent::ScreenXAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "dataTransfer", { (intptr_t)JSMouseEvent::DataTransferAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "button", { (intptr_t)JSMouseEvent::ButtonAttrNum }, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSMouseEventTable = 
{
    3, 65, JSMouseEventTableEntries, 63
};

/* Hash table for constructor */

static const HashEntry JSMouseEventConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSMouseEventConstructorTable = 
{
    3, 1, JSMouseEventConstructorTableEntries, 0
};

class JSMouseEventConstructor : public DOMObject {
public:
    JSMouseEventConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSMouseEventPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSMouseEventConstructor::info = { "MouseEventConstructor", 0, &JSMouseEventConstructorTable };

bool JSMouseEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMouseEventConstructor, DOMObject>(exec, &JSMouseEventConstructorTable, this, propertyName, slot);
}

JSValue* JSMouseEventConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSMouseEventPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "initMouseEvent", { (intptr_t)jsMouseEventPrototypeFunctionInitMouseEvent }, DontDelete|Function, 15, 0 }
};

static const HashTable JSMouseEventPrototypeTable = 
{
    3, 2, JSMouseEventPrototypeTableEntries, 1
};

const ClassInfo JSMouseEventPrototype::info = { "MouseEventPrototype", 0, &JSMouseEventPrototypeTable };

JSObject* JSMouseEventPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSMouseEventPrototype>(exec, "[[JSMouseEvent.prototype]]");
}

bool JSMouseEventPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSMouseEventPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSMouseEvent::info = { "MouseEvent", &JSUIEvent::info, &JSMouseEventTable };

JSMouseEvent::JSMouseEvent(JSObject* prototype, MouseEvent* impl)
    : JSUIEvent(prototype, impl)
{
}

bool JSMouseEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMouseEvent, Base>(exec, &JSMouseEventTable, this, propertyName, slot);
}

JSValue* JSMouseEvent::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case ScreenXAttrNum: {
        MouseEvent* imp = static_cast<MouseEvent*>(impl());
        return jsNumber(imp->screenX());
    }
    case ScreenYAttrNum: {
        MouseEvent* imp = static_cast<MouseEvent*>(impl());
        return jsNumber(imp->screenY());
    }
    case ClientXAttrNum: {
        MouseEvent* imp = static_cast<MouseEvent*>(impl());
        return jsNumber(imp->clientX());
    }
    case ClientYAttrNum: {
        MouseEvent* imp = static_cast<MouseEvent*>(impl());
        return jsNumber(imp->clientY());
    }
    case CtrlKeyAttrNum: {
        MouseEvent* imp = static_cast<MouseEvent*>(impl());
        return jsBoolean(imp->ctrlKey());
    }
    case ShiftKeyAttrNum: {
        MouseEvent* imp = static_cast<MouseEvent*>(impl());
        return jsBoolean(imp->shiftKey());
    }
    case AltKeyAttrNum: {
        MouseEvent* imp = static_cast<MouseEvent*>(impl());
        return jsBoolean(imp->altKey());
    }
    case MetaKeyAttrNum: {
        MouseEvent* imp = static_cast<MouseEvent*>(impl());
        return jsBoolean(imp->metaKey());
    }
    case ButtonAttrNum: {
        MouseEvent* imp = static_cast<MouseEvent*>(impl());
        return jsNumber(imp->button());
    }
    case RelatedTargetAttrNum: {
        MouseEvent* imp = static_cast<MouseEvent*>(impl());
        return toJS(exec, WTF::getPtr(imp->relatedTarget()));
    }
    case OffsetXAttrNum: {
        MouseEvent* imp = static_cast<MouseEvent*>(impl());
        return jsNumber(imp->offsetX());
    }
    case OffsetYAttrNum: {
        MouseEvent* imp = static_cast<MouseEvent*>(impl());
        return jsNumber(imp->offsetY());
    }
    case XAttrNum: {
        MouseEvent* imp = static_cast<MouseEvent*>(impl());
        return jsNumber(imp->x());
    }
    case YAttrNum: {
        MouseEvent* imp = static_cast<MouseEvent*>(impl());
        return jsNumber(imp->y());
    }
    case FromElementAttrNum: {
        MouseEvent* imp = static_cast<MouseEvent*>(impl());
        return toJS(exec, WTF::getPtr(imp->fromElement()));
    }
    case ToElementAttrNum: {
        MouseEvent* imp = static_cast<MouseEvent*>(impl());
        return toJS(exec, WTF::getPtr(imp->toElement()));
    }
    case DataTransferAttrNum: {
        MouseEvent* imp = static_cast<MouseEvent*>(impl());
        return toJS(exec, WTF::getPtr(imp->dataTransfer()));
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSMouseEvent::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSMouseEventConstructor>(exec, "[[MouseEvent.constructor]]");
}

JSValue* jsMouseEventPrototypeFunctionInitMouseEvent(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSMouseEvent::info))
        return throwError(exec, TypeError);
    JSMouseEvent* castedThisObj = static_cast<JSMouseEvent*>(thisObj);
    MouseEvent* imp = static_cast<MouseEvent*>(castedThisObj->impl());
    AtomicString type = args[0]->toString(exec);
    bool canBubble = args[1]->toBoolean(exec);
    bool cancelable = args[2]->toBoolean(exec);
    DOMWindow* view = toDOMWindow(args[3]);
    int detail = args[4]->toInt32(exec);
    int screenX = args[5]->toInt32(exec);
    int screenY = args[6]->toInt32(exec);
    int clientX = args[7]->toInt32(exec);
    int clientY = args[8]->toInt32(exec);
    bool ctrlKey = args[9]->toBoolean(exec);
    bool altKey = args[10]->toBoolean(exec);
    bool shiftKey = args[11]->toBoolean(exec);
    bool metaKey = args[12]->toBoolean(exec);
    unsigned short button = args[13]->toInt32(exec);
    EventTargetNode* relatedTarget = toEventTargetNode(args[14]);

    imp->initMouseEvent(type, canBubble, cancelable, view, detail, screenX, screenY, clientX, clientY, ctrlKey, altKey, shiftKey, metaKey, button, relatedTarget);
    return jsUndefined();
}


}
