/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(CROSS_DOCUMENT_MESSAGING)

#include "JSMessageEvent.h"

#include <wtf/GetPtr.h>

#include "DOMWindow.h"
#include "JSDOMWindow.h"
#include "KURL.h"
#include "MessageEvent.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSMessageEventTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "data", { (intptr_t)JSMessageEvent::DataAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "domain", { (intptr_t)JSMessageEvent::DomainAttrNum }, DontDelete|ReadOnly, 0, &JSMessageEventTableEntries[16] },
    { "source", { (intptr_t)JSMessageEvent::SourceAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "uri", { (intptr_t)JSMessageEvent::UriAttrNum }, DontDelete|ReadOnly, 0, &JSMessageEventTableEntries[17] },
    { "constructor", { (intptr_t)JSMessageEvent::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSMessageEventTable = 
{
    3, 18, JSMessageEventTableEntries, 15
};

/* Hash table for constructor */

static const HashEntry JSMessageEventConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSMessageEventConstructorTable = 
{
    3, 1, JSMessageEventConstructorTableEntries, 0
};

class JSMessageEventConstructor : public DOMObject {
public:
    JSMessageEventConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSMessageEventPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSMessageEventConstructor::info = { "MessageEventConstructor", 0, &JSMessageEventConstructorTable };

bool JSMessageEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMessageEventConstructor, DOMObject>(exec, &JSMessageEventConstructorTable, this, propertyName, slot);
}

JSValue* JSMessageEventConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSMessageEventPrototypeTableEntries[] =
{
    { "initMessageEvent", { (intptr_t)jsMessageEventPrototypeFunctionInitMessageEvent }, DontDelete|Function, 7, 0 },
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSMessageEventPrototypeTable = 
{
    3, 2, JSMessageEventPrototypeTableEntries, 1
};

const ClassInfo JSMessageEventPrototype::info = { "MessageEventPrototype", 0, &JSMessageEventPrototypeTable };

JSObject* JSMessageEventPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSMessageEventPrototype>(exec, "[[JSMessageEvent.prototype]]");
}

bool JSMessageEventPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSMessageEventPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSMessageEvent::info = { "MessageEvent", &JSEvent::info, &JSMessageEventTable };

JSMessageEvent::JSMessageEvent(JSObject* prototype, MessageEvent* impl)
    : JSEvent(prototype, impl)
{
}

bool JSMessageEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMessageEvent, Base>(exec, &JSMessageEventTable, this, propertyName, slot);
}

JSValue* JSMessageEvent::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case DataAttrNum: {
        MessageEvent* imp = static_cast<MessageEvent*>(impl());
        return jsString(imp->data());
    }
    case DomainAttrNum: {
        MessageEvent* imp = static_cast<MessageEvent*>(impl());
        return jsString(imp->domain());
    }
    case UriAttrNum: {
        MessageEvent* imp = static_cast<MessageEvent*>(impl());
        return jsString(imp->uri());
    }
    case SourceAttrNum: {
        MessageEvent* imp = static_cast<MessageEvent*>(impl());
        return toJS(exec, WTF::getPtr(imp->source()));
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSMessageEvent::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSMessageEventConstructor>(exec, "[[MessageEvent.constructor]]");
}

JSValue* jsMessageEventPrototypeFunctionInitMessageEvent(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSMessageEvent::info))
        return throwError(exec, TypeError);
    JSMessageEvent* castedThisObj = static_cast<JSMessageEvent*>(thisObj);
    MessageEvent* imp = static_cast<MessageEvent*>(castedThisObj->impl());
    String typeArg = args[0]->toString(exec);
    bool canBubbleArg = args[1]->toBoolean(exec);
    bool cancelableArg = args[2]->toBoolean(exec);
    String dataArg = args[3]->toString(exec);
    String domainArg = args[4]->toString(exec);
    String uriArg = args[5]->toString(exec);
    DOMWindow* sourceArg = toDOMWindow(args[6]);

    imp->initMessageEvent(typeArg, canBubbleArg, cancelableArg, dataArg, domainArg, uriArg, sourceArg);
    return jsUndefined();
}


}

#endif // ENABLE(CROSS_DOCUMENT_MESSAGING)
