/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSMediaList.h"

#include <wtf/GetPtr.h>

#include <kjs/PropertyNameArray.h>
#include "KURL.h"
#include "MediaList.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSMediaListTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "length", { (intptr_t)JSMediaList::LengthAttrNum }, DontDelete|ReadOnly, 0, &JSMediaListTableEntries[8] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "mediaText", { (intptr_t)JSMediaList::MediaTextAttrNum }, DontDelete, 0, 0 },
    { "constructor", { (intptr_t)JSMediaList::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSMediaListTable = 
{
    3, 9, JSMediaListTableEntries, 7
};

/* Hash table for constructor */

static const HashEntry JSMediaListConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSMediaListConstructorTable = 
{
    3, 1, JSMediaListConstructorTableEntries, 0
};

class JSMediaListConstructor : public DOMObject {
public:
    JSMediaListConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSMediaListPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSMediaListConstructor::info = { "MediaListConstructor", 0, &JSMediaListConstructorTable };

bool JSMediaListConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMediaListConstructor, DOMObject>(exec, &JSMediaListConstructorTable, this, propertyName, slot);
}

JSValue* JSMediaListConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSMediaListPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "appendMedium", { (intptr_t)jsMediaListPrototypeFunctionAppendMedium }, DontDelete|Function, 1, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "deleteMedium", { (intptr_t)jsMediaListPrototypeFunctionDeleteMedium }, DontDelete|Function, 1, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "item", { (intptr_t)jsMediaListPrototypeFunctionItem }, DontDelete|Function, 1, 0 }
};

static const HashTable JSMediaListPrototypeTable = 
{
    3, 8, JSMediaListPrototypeTableEntries, 7
};

const ClassInfo JSMediaListPrototype::info = { "MediaListPrototype", 0, &JSMediaListPrototypeTable };

JSObject* JSMediaListPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSMediaListPrototype>(exec, "[[JSMediaList.prototype]]");
}

bool JSMediaListPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSMediaListPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSMediaList::info = { "MediaList", 0, &JSMediaListTable };

JSMediaList::JSMediaList(JSObject* prototype, MediaList* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSMediaList::~JSMediaList()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSMediaList::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    const HashEntry* entry = Lookup::findEntry(&JSMediaListTable, propertyName);
    if (entry) {
        slot.setStaticEntry(this, entry, staticValueGetter<JSMediaList>);
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<MediaList*>(impl())->length()) {
        slot.setCustomIndex(this, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSMediaList, Base>(exec, &JSMediaListTable, this, propertyName, slot);
}

bool JSMediaList::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    if (propertyName < static_cast<MediaList*>(impl())->length()) {
        slot.setCustomIndex(this, propertyName, indexGetter);
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(propertyName), slot);
}

JSValue* JSMediaList::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case MediaTextAttrNum: {
        MediaList* imp = static_cast<MediaList*>(impl());
        return jsStringOrNull(imp->mediaText());
    }
    case LengthAttrNum: {
        MediaList* imp = static_cast<MediaList*>(impl());
        return jsNumber(imp->length());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSMediaList::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSMediaList, Base>(exec, propertyName, value, &JSMediaListTable, this);
}

void JSMediaList::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case MediaTextAttrNum: {
        MediaList* imp = static_cast<MediaList*>(impl());
        ExceptionCode ec = 0;
        imp->setMediaText(valueToStringWithNullCheck(exec, value), ec);
        setDOMException(exec, ec);
        break;
    }
    }
}

void JSMediaList::getPropertyNames(ExecState* exec, PropertyNameArray& propertyNames)
{
    for (unsigned i = 0; i < static_cast<MediaList*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(i));
     Base::getPropertyNames(exec, propertyNames);
}

JSValue* JSMediaList::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSMediaListConstructor>(exec, "[[MediaList.constructor]]");
}

JSValue* jsMediaListPrototypeFunctionItem(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSMediaList::info))
        return throwError(exec, TypeError);
    JSMediaList* castedThisObj = static_cast<JSMediaList*>(thisObj);
    MediaList* imp = static_cast<MediaList*>(castedThisObj->impl());
    unsigned index = args[0]->toInt32(exec);


    KJS::JSValue* result = jsStringOrNull(imp->item(index));
    return result;
}

JSValue* jsMediaListPrototypeFunctionDeleteMedium(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSMediaList::info))
        return throwError(exec, TypeError);
    JSMediaList* castedThisObj = static_cast<JSMediaList*>(thisObj);
    MediaList* imp = static_cast<MediaList*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    String oldMedium = args[0]->toString(exec);

    imp->deleteMedium(oldMedium, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsMediaListPrototypeFunctionAppendMedium(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSMediaList::info))
        return throwError(exec, TypeError);
    JSMediaList* castedThisObj = static_cast<JSMediaList*>(thisObj);
    MediaList* imp = static_cast<MediaList*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    String newMedium = args[0]->toString(exec);

    imp->appendMedium(newMedium, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}


JSValue* JSMediaList::indexGetter(ExecState* exec, JSObject* originalObject, const Identifier& propertyName, const PropertySlot& slot)
{
    JSMediaList* thisObj = static_cast<JSMediaList*>(slot.slotBase());
    return jsStringOrNull(thisObj->impl()->item(slot.index()));
}
KJS::JSValue* toJS(KJS::ExecState* exec, MediaList* obj)
{
    return cacheDOMObject<MediaList, JSMediaList, JSMediaListPrototype>(exec, obj);
}
MediaList* toMediaList(KJS::JSValue* val)
{
    return val->isObject(&JSMediaList::info) ? static_cast<JSMediaList*>(val)->impl() : 0;
}

}
