/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSKeyboardEvent.h"

#include <wtf/GetPtr.h>

#include "JSDOMWindow.h"
#include "KURL.h"
#include "KeyboardEvent.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSKeyboardEventTableEntries[] =
{
    { "keyLocation", { (intptr_t)JSKeyboardEvent::KeyLocationAttrNum }, DontDelete|ReadOnly, 0, &JSKeyboardEventTableEntries[17] },
    { 0, { 0 }, 0, 0, 0 },
    { "ctrlKey", { (intptr_t)JSKeyboardEvent::CtrlKeyAttrNum }, DontDelete|ReadOnly, 0, &JSKeyboardEventTableEntries[16] },
    { "shiftKey", { (intptr_t)JSKeyboardEvent::ShiftKeyAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "keyIdentifier", { (intptr_t)JSKeyboardEvent::KeyIdentifierAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "altKey", { (intptr_t)JSKeyboardEvent::AltKeyAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "constructor", { (intptr_t)JSKeyboardEvent::ConstructorAttrNum }, DontEnum, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "metaKey", { (intptr_t)JSKeyboardEvent::MetaKeyAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "altGraphKey", { (intptr_t)JSKeyboardEvent::AltGraphKeyAttrNum }, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSKeyboardEventTable = 
{
    3, 18, JSKeyboardEventTableEntries, 15
};

/* Hash table for constructor */

static const HashEntry JSKeyboardEventConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSKeyboardEventConstructorTable = 
{
    3, 1, JSKeyboardEventConstructorTableEntries, 0
};

class JSKeyboardEventConstructor : public DOMObject {
public:
    JSKeyboardEventConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSKeyboardEventPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSKeyboardEventConstructor::info = { "KeyboardEventConstructor", 0, &JSKeyboardEventConstructorTable };

bool JSKeyboardEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSKeyboardEventConstructor, DOMObject>(exec, &JSKeyboardEventConstructorTable, this, propertyName, slot);
}

JSValue* JSKeyboardEventConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSKeyboardEventPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "initKeyboardEvent", { (intptr_t)jsKeyboardEventPrototypeFunctionInitKeyboardEvent }, DontDelete|Function, 11, 0 }
};

static const HashTable JSKeyboardEventPrototypeTable = 
{
    3, 2, JSKeyboardEventPrototypeTableEntries, 1
};

const ClassInfo JSKeyboardEventPrototype::info = { "KeyboardEventPrototype", 0, &JSKeyboardEventPrototypeTable };

JSObject* JSKeyboardEventPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSKeyboardEventPrototype>(exec, "[[JSKeyboardEvent.prototype]]");
}

bool JSKeyboardEventPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSKeyboardEventPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSKeyboardEvent::info = { "KeyboardEvent", &JSUIEvent::info, &JSKeyboardEventTable };

JSKeyboardEvent::JSKeyboardEvent(JSObject* prototype, KeyboardEvent* impl)
    : JSUIEvent(prototype, impl)
{
}

bool JSKeyboardEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSKeyboardEvent, Base>(exec, &JSKeyboardEventTable, this, propertyName, slot);
}

JSValue* JSKeyboardEvent::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case KeyIdentifierAttrNum: {
        KeyboardEvent* imp = static_cast<KeyboardEvent*>(impl());
        return jsString(imp->keyIdentifier());
    }
    case KeyLocationAttrNum: {
        KeyboardEvent* imp = static_cast<KeyboardEvent*>(impl());
        return jsNumber(imp->keyLocation());
    }
    case CtrlKeyAttrNum: {
        KeyboardEvent* imp = static_cast<KeyboardEvent*>(impl());
        return jsBoolean(imp->ctrlKey());
    }
    case ShiftKeyAttrNum: {
        KeyboardEvent* imp = static_cast<KeyboardEvent*>(impl());
        return jsBoolean(imp->shiftKey());
    }
    case AltKeyAttrNum: {
        KeyboardEvent* imp = static_cast<KeyboardEvent*>(impl());
        return jsBoolean(imp->altKey());
    }
    case MetaKeyAttrNum: {
        KeyboardEvent* imp = static_cast<KeyboardEvent*>(impl());
        return jsBoolean(imp->metaKey());
    }
    case AltGraphKeyAttrNum: {
        KeyboardEvent* imp = static_cast<KeyboardEvent*>(impl());
        return jsBoolean(imp->altGraphKey());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSKeyboardEvent::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSKeyboardEventConstructor>(exec, "[[KeyboardEvent.constructor]]");
}

JSValue* jsKeyboardEventPrototypeFunctionInitKeyboardEvent(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSKeyboardEvent::info))
        return throwError(exec, TypeError);
    JSKeyboardEvent* castedThisObj = static_cast<JSKeyboardEvent*>(thisObj);
    KeyboardEvent* imp = static_cast<KeyboardEvent*>(castedThisObj->impl());
    AtomicString type = args[0]->toString(exec);
    bool canBubble = args[1]->toBoolean(exec);
    bool cancelable = args[2]->toBoolean(exec);
    DOMWindow* view = toDOMWindow(args[3]);
    String keyIdentifier = args[4]->toString(exec);
    unsigned keyLocation = args[5]->toInt32(exec);
    bool ctrlKey = args[6]->toBoolean(exec);
    bool altKey = args[7]->toBoolean(exec);
    bool shiftKey = args[8]->toBoolean(exec);
    bool metaKey = args[9]->toBoolean(exec);
    bool altGraphKey = args[10]->toBoolean(exec);

    imp->initKeyboardEvent(type, canBubble, cancelable, view, keyIdentifier, keyLocation, ctrlKey, altKey, shiftKey, metaKey, altGraphKey);
    return jsUndefined();
}


}
