/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSImageData.h"

#include <wtf/GetPtr.h>

#include "CanvasPixelArray.h"
#include "ImageData.h"
#include "JSCanvasPixelArray.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSImageDataTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "height", { (intptr_t)JSImageData::HeightAttrNum }, DontDelete|ReadOnly, 0, &JSImageDataTableEntries[9] },
    { 0, { 0 }, 0, 0, 0 },
    { "width", { (intptr_t)JSImageData::WidthAttrNum }, DontDelete|ReadOnly, 0, &JSImageDataTableEntries[8] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "data", { (intptr_t)JSImageData::DataAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "constructor", { (intptr_t)JSImageData::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSImageDataTable = 
{
    3, 10, JSImageDataTableEntries, 7
};

/* Hash table for constructor */

static const HashEntry JSImageDataConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSImageDataConstructorTable = 
{
    3, 1, JSImageDataConstructorTableEntries, 0
};

class JSImageDataConstructor : public DOMObject {
public:
    JSImageDataConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSImageDataPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSImageDataConstructor::info = { "ImageDataConstructor", 0, &JSImageDataConstructorTable };

bool JSImageDataConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSImageDataConstructor, DOMObject>(exec, &JSImageDataConstructorTable, this, propertyName, slot);
}

JSValue* JSImageDataConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSImageDataPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSImageDataPrototypeTable = 
{
    3, 1, JSImageDataPrototypeTableEntries, 0
};

const ClassInfo JSImageDataPrototype::info = { "ImageDataPrototype", 0, &JSImageDataPrototypeTable };

JSObject* JSImageDataPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSImageDataPrototype>(exec, "[[JSImageData.prototype]]");
}

const ClassInfo JSImageData::info = { "ImageData", 0, &JSImageDataTable };

JSImageData::JSImageData(JSObject* prototype, ImageData* impl)
    : DOMObject(prototype)
    , m_impl(impl)
{
}

JSImageData::~JSImageData()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());

}

bool JSImageData::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSImageData, Base>(exec, &JSImageDataTable, this, propertyName, slot);
}

JSValue* JSImageData::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case WidthAttrNum: {
        ImageData* imp = static_cast<ImageData*>(impl());
        return jsNumber(imp->width());
    }
    case HeightAttrNum: {
        ImageData* imp = static_cast<ImageData*>(impl());
        return jsNumber(imp->height());
    }
    case DataAttrNum: {
        ImageData* imp = static_cast<ImageData*>(impl());
        return toJS(exec, WTF::getPtr(imp->data()));
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSImageData::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSImageDataConstructor>(exec, "[[ImageData.constructor]]");
}

KJS::JSValue* toJS(KJS::ExecState* exec, ImageData* obj)
{
    return cacheDOMObject<ImageData, JSImageData, JSImageDataPrototype>(exec, obj);
}
ImageData* toImageData(KJS::JSValue* val)
{
    return val->isObject(&JSImageData::info) ? static_cast<JSImageData*>(val)->impl() : 0;
}

}
