/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLTitleElement.h"

#include <wtf/GetPtr.h>

#include "HTMLTitleElement.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLTitleElementTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "constructor", { (intptr_t)JSHTMLTitleElement::ConstructorAttrNum }, DontEnum, 0, 0 },
    { "text", { (intptr_t)JSHTMLTitleElement::TextAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLTitleElementTable = 
{
    3, 4, JSHTMLTitleElementTableEntries, 3
};

/* Hash table for constructor */

static const HashEntry JSHTMLTitleElementConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLTitleElementConstructorTable = 
{
    3, 1, JSHTMLTitleElementConstructorTableEntries, 0
};

class JSHTMLTitleElementConstructor : public DOMObject {
public:
    JSHTMLTitleElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLTitleElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLTitleElementConstructor::info = { "HTMLTitleElementConstructor", 0, &JSHTMLTitleElementConstructorTable };

bool JSHTMLTitleElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLTitleElementConstructor, DOMObject>(exec, &JSHTMLTitleElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLTitleElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLTitleElementPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLTitleElementPrototypeTable = 
{
    3, 1, JSHTMLTitleElementPrototypeTableEntries, 0
};

const ClassInfo JSHTMLTitleElementPrototype::info = { "HTMLTitleElementPrototype", 0, &JSHTMLTitleElementPrototypeTable };

JSObject* JSHTMLTitleElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLTitleElementPrototype>(exec, "[[JSHTMLTitleElement.prototype]]");
}

const ClassInfo JSHTMLTitleElement::info = { "HTMLTitleElement", &JSHTMLElement::info, &JSHTMLTitleElementTable };

JSHTMLTitleElement::JSHTMLTitleElement(JSObject* prototype, HTMLTitleElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLTitleElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLTitleElement, Base>(exec, &JSHTMLTitleElementTable, this, propertyName, slot);
}

JSValue* JSHTMLTitleElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case TextAttrNum: {
        HTMLTitleElement* imp = static_cast<HTMLTitleElement*>(impl());
        return jsString(imp->text());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLTitleElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLTitleElement, Base>(exec, propertyName, value, &JSHTMLTitleElementTable, this);
}

void JSHTMLTitleElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case TextAttrNum: {
        HTMLTitleElement* imp = static_cast<HTMLTitleElement*>(impl());
        imp->setText(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLTitleElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLTitleElementConstructor>(exec, "[[HTMLTitleElement.constructor]]");
}


}
