/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLTableRowElement.h"

#include <wtf/GetPtr.h>

#include "HTMLCollection.h"
#include "HTMLElement.h"
#include "HTMLTableRowElement.h"
#include "JSHTMLCollection.h"
#include "JSHTMLElement.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLTableRowElementTableEntries[] =
{
    { "bgColor", { (intptr_t)JSHTMLTableRowElement::BgColorAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "ch", { (intptr_t)JSHTMLTableRowElement::ChAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "rowIndex", { (intptr_t)JSHTMLTableRowElement::RowIndexAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "cells", { (intptr_t)JSHTMLTableRowElement::CellsAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "constructor", { (intptr_t)JSHTMLTableRowElement::ConstructorAttrNum }, DontEnum, 0, 0 },
    { "vAlign", { (intptr_t)JSHTMLTableRowElement::VAlignAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "sectionRowIndex", { (intptr_t)JSHTMLTableRowElement::SectionRowIndexAttrNum }, DontDelete|ReadOnly, 0, &JSHTMLTableRowElementTableEntries[32] },
    { "align", { (intptr_t)JSHTMLTableRowElement::AlignAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "chOff", { (intptr_t)JSHTMLTableRowElement::ChOffAttrNum }, DontDelete, 0, 0 }
};

static const HashTable JSHTMLTableRowElementTable = 
{
    3, 33, JSHTMLTableRowElementTableEntries, 31
};

/* Hash table for constructor */

static const HashEntry JSHTMLTableRowElementConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLTableRowElementConstructorTable = 
{
    3, 1, JSHTMLTableRowElementConstructorTableEntries, 0
};

class JSHTMLTableRowElementConstructor : public DOMObject {
public:
    JSHTMLTableRowElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLTableRowElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLTableRowElementConstructor::info = { "HTMLTableRowElementConstructor", 0, &JSHTMLTableRowElementConstructorTable };

bool JSHTMLTableRowElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLTableRowElementConstructor, DOMObject>(exec, &JSHTMLTableRowElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLTableRowElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLTableRowElementPrototypeTableEntries[] =
{
    { "insertCell", { (intptr_t)jsHTMLTableRowElementPrototypeFunctionInsertCell }, DontDelete|Function, 1, 0 },
    { "deleteCell", { (intptr_t)jsHTMLTableRowElementPrototypeFunctionDeleteCell }, DontDelete|Function, 1, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLTableRowElementPrototypeTable = 
{
    3, 4, JSHTMLTableRowElementPrototypeTableEntries, 3
};

const ClassInfo JSHTMLTableRowElementPrototype::info = { "HTMLTableRowElementPrototype", 0, &JSHTMLTableRowElementPrototypeTable };

JSObject* JSHTMLTableRowElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLTableRowElementPrototype>(exec, "[[JSHTMLTableRowElement.prototype]]");
}

bool JSHTMLTableRowElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLTableRowElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSHTMLTableRowElement::info = { "HTMLTableRowElement", &JSHTMLElement::info, &JSHTMLTableRowElementTable };

JSHTMLTableRowElement::JSHTMLTableRowElement(JSObject* prototype, HTMLTableRowElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLTableRowElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLTableRowElement, Base>(exec, &JSHTMLTableRowElementTable, this, propertyName, slot);
}

JSValue* JSHTMLTableRowElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case RowIndexAttrNum: {
        HTMLTableRowElement* imp = static_cast<HTMLTableRowElement*>(impl());
        return jsNumber(imp->rowIndex());
    }
    case SectionRowIndexAttrNum: {
        HTMLTableRowElement* imp = static_cast<HTMLTableRowElement*>(impl());
        return jsNumber(imp->sectionRowIndex());
    }
    case CellsAttrNum: {
        HTMLTableRowElement* imp = static_cast<HTMLTableRowElement*>(impl());
        return toJS(exec, WTF::getPtr(imp->cells()));
    }
    case AlignAttrNum: {
        HTMLTableRowElement* imp = static_cast<HTMLTableRowElement*>(impl());
        return jsString(imp->align());
    }
    case BgColorAttrNum: {
        HTMLTableRowElement* imp = static_cast<HTMLTableRowElement*>(impl());
        return jsString(imp->bgColor());
    }
    case ChAttrNum: {
        HTMLTableRowElement* imp = static_cast<HTMLTableRowElement*>(impl());
        return jsString(imp->ch());
    }
    case ChOffAttrNum: {
        HTMLTableRowElement* imp = static_cast<HTMLTableRowElement*>(impl());
        return jsString(imp->chOff());
    }
    case VAlignAttrNum: {
        HTMLTableRowElement* imp = static_cast<HTMLTableRowElement*>(impl());
        return jsString(imp->vAlign());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLTableRowElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLTableRowElement, Base>(exec, propertyName, value, &JSHTMLTableRowElementTable, this);
}

void JSHTMLTableRowElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case AlignAttrNum: {
        HTMLTableRowElement* imp = static_cast<HTMLTableRowElement*>(impl());
        imp->setAlign(valueToStringWithNullCheck(exec, value));
        break;
    }
    case BgColorAttrNum: {
        HTMLTableRowElement* imp = static_cast<HTMLTableRowElement*>(impl());
        imp->setBgColor(valueToStringWithNullCheck(exec, value));
        break;
    }
    case ChAttrNum: {
        HTMLTableRowElement* imp = static_cast<HTMLTableRowElement*>(impl());
        imp->setCh(valueToStringWithNullCheck(exec, value));
        break;
    }
    case ChOffAttrNum: {
        HTMLTableRowElement* imp = static_cast<HTMLTableRowElement*>(impl());
        imp->setChOff(valueToStringWithNullCheck(exec, value));
        break;
    }
    case VAlignAttrNum: {
        HTMLTableRowElement* imp = static_cast<HTMLTableRowElement*>(impl());
        imp->setVAlign(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLTableRowElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLTableRowElementConstructor>(exec, "[[HTMLTableRowElement.constructor]]");
}

JSValue* jsHTMLTableRowElementPrototypeFunctionInsertCell(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSHTMLTableRowElement::info))
        return throwError(exec, TypeError);
    JSHTMLTableRowElement* castedThisObj = static_cast<JSHTMLTableRowElement*>(thisObj);
    HTMLTableRowElement* imp = static_cast<HTMLTableRowElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    int index = args[0]->toInt32(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->insertCell(index, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue* jsHTMLTableRowElementPrototypeFunctionDeleteCell(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSHTMLTableRowElement::info))
        return throwError(exec, TypeError);
    JSHTMLTableRowElement* castedThisObj = static_cast<JSHTMLTableRowElement*>(thisObj);
    HTMLTableRowElement* imp = static_cast<HTMLTableRowElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    int index = args[0]->toInt32(exec);

    imp->deleteCell(index, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}


}
