/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLTableColElement.h"

#include <wtf/GetPtr.h>

#include "HTMLTableColElement.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLTableColElementTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "width", { (intptr_t)JSHTMLTableColElement::WidthAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "ch", { (intptr_t)JSHTMLTableColElement::ChAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "constructor", { (intptr_t)JSHTMLTableColElement::ConstructorAttrNum }, DontEnum, 0, 0 },
    { "vAlign", { (intptr_t)JSHTMLTableColElement::VAlignAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "chOff", { (intptr_t)JSHTMLTableColElement::ChOffAttrNum }, DontDelete, 0, &JSHTMLTableColElementTableEntries[16] },
    { "align", { (intptr_t)JSHTMLTableColElement::AlignAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "span", { (intptr_t)JSHTMLTableColElement::SpanAttrNum }, DontDelete, 0, 0 }
};

static const HashTable JSHTMLTableColElementTable = 
{
    3, 17, JSHTMLTableColElementTableEntries, 15
};

/* Hash table for constructor */

static const HashEntry JSHTMLTableColElementConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLTableColElementConstructorTable = 
{
    3, 1, JSHTMLTableColElementConstructorTableEntries, 0
};

class JSHTMLTableColElementConstructor : public DOMObject {
public:
    JSHTMLTableColElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLTableColElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLTableColElementConstructor::info = { "HTMLTableColElementConstructor", 0, &JSHTMLTableColElementConstructorTable };

bool JSHTMLTableColElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLTableColElementConstructor, DOMObject>(exec, &JSHTMLTableColElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLTableColElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLTableColElementPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLTableColElementPrototypeTable = 
{
    3, 1, JSHTMLTableColElementPrototypeTableEntries, 0
};

const ClassInfo JSHTMLTableColElementPrototype::info = { "HTMLTableColElementPrototype", 0, &JSHTMLTableColElementPrototypeTable };

JSObject* JSHTMLTableColElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLTableColElementPrototype>(exec, "[[JSHTMLTableColElement.prototype]]");
}

const ClassInfo JSHTMLTableColElement::info = { "HTMLTableColElement", &JSHTMLElement::info, &JSHTMLTableColElementTable };

JSHTMLTableColElement::JSHTMLTableColElement(JSObject* prototype, HTMLTableColElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLTableColElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLTableColElement, Base>(exec, &JSHTMLTableColElementTable, this, propertyName, slot);
}

JSValue* JSHTMLTableColElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case AlignAttrNum: {
        HTMLTableColElement* imp = static_cast<HTMLTableColElement*>(impl());
        return jsString(imp->align());
    }
    case ChAttrNum: {
        HTMLTableColElement* imp = static_cast<HTMLTableColElement*>(impl());
        return jsString(imp->ch());
    }
    case ChOffAttrNum: {
        HTMLTableColElement* imp = static_cast<HTMLTableColElement*>(impl());
        return jsString(imp->chOff());
    }
    case SpanAttrNum: {
        HTMLTableColElement* imp = static_cast<HTMLTableColElement*>(impl());
        return jsNumber(imp->span());
    }
    case VAlignAttrNum: {
        HTMLTableColElement* imp = static_cast<HTMLTableColElement*>(impl());
        return jsString(imp->vAlign());
    }
    case WidthAttrNum: {
        HTMLTableColElement* imp = static_cast<HTMLTableColElement*>(impl());
        return jsString(imp->width());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLTableColElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLTableColElement, Base>(exec, propertyName, value, &JSHTMLTableColElementTable, this);
}

void JSHTMLTableColElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case AlignAttrNum: {
        HTMLTableColElement* imp = static_cast<HTMLTableColElement*>(impl());
        imp->setAlign(valueToStringWithNullCheck(exec, value));
        break;
    }
    case ChAttrNum: {
        HTMLTableColElement* imp = static_cast<HTMLTableColElement*>(impl());
        imp->setCh(valueToStringWithNullCheck(exec, value));
        break;
    }
    case ChOffAttrNum: {
        HTMLTableColElement* imp = static_cast<HTMLTableColElement*>(impl());
        imp->setChOff(valueToStringWithNullCheck(exec, value));
        break;
    }
    case SpanAttrNum: {
        HTMLTableColElement* imp = static_cast<HTMLTableColElement*>(impl());
        imp->setSpan(value->toInt32(exec));
        break;
    }
    case VAlignAttrNum: {
        HTMLTableColElement* imp = static_cast<HTMLTableColElement*>(impl());
        imp->setVAlign(valueToStringWithNullCheck(exec, value));
        break;
    }
    case WidthAttrNum: {
        HTMLTableColElement* imp = static_cast<HTMLTableColElement*>(impl());
        imp->setWidth(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLTableColElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLTableColElementConstructor>(exec, "[[HTMLTableColElement.constructor]]");
}


}
