/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLSelectElement.h"

#include <wtf/GetPtr.h>

#include <kjs/PropertyNameArray.h>
#include "ExceptionCode.h"
#include "HTMLFormElement.h"
#include "HTMLOptionsCollection.h"
#include "HTMLSelectElement.h"
#include "JSHTMLElement.h"
#include "JSHTMLFormElement.h"
#include "JSHTMLOptionsCollection.h"
#include "JSNode.h"
#include "KURL.h"
#include "Node.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLSelectElementTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "disabled", { (intptr_t)JSHTMLSelectElement::DisabledAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "selectedIndex", { (intptr_t)JSHTMLSelectElement::SelectedIndexAttrNum }, DontDelete, 0, &JSHTMLSelectElementTableEntries[32] },
    { 0, { 0 }, 0, 0, 0 },
    { "form", { (intptr_t)JSHTMLSelectElement::FormAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "multiple", { (intptr_t)JSHTMLSelectElement::MultipleAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "size", { (intptr_t)JSHTMLSelectElement::SizeAttrNum }, DontDelete, 0, 0 },
    { "length", { (intptr_t)JSHTMLSelectElement::LengthAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "options", { (intptr_t)JSHTMLSelectElement::OptionsAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "name", { (intptr_t)JSHTMLSelectElement::NameAttrNum }, DontDelete, 0, &JSHTMLSelectElementTableEntries[33] },
    { 0, { 0 }, 0, 0, 0 },
    { "type", { (intptr_t)JSHTMLSelectElement::TypeAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "tabIndex", { (intptr_t)JSHTMLSelectElement::TabIndexAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "value", { (intptr_t)JSHTMLSelectElement::ValueAttrNum }, DontDelete, 0, 0 },
    { "constructor", { (intptr_t)JSHTMLSelectElement::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSHTMLSelectElementTable = 
{
    3, 34, JSHTMLSelectElementTableEntries, 31
};

/* Hash table for constructor */

static const HashEntry JSHTMLSelectElementConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLSelectElementConstructorTable = 
{
    3, 1, JSHTMLSelectElementConstructorTableEntries, 0
};

class JSHTMLSelectElementConstructor : public DOMObject {
public:
    JSHTMLSelectElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLSelectElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLSelectElementConstructor::info = { "HTMLSelectElementConstructor", 0, &JSHTMLSelectElementConstructorTable };

bool JSHTMLSelectElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLSelectElementConstructor, DOMObject>(exec, &JSHTMLSelectElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLSelectElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLSelectElementPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "blur", { (intptr_t)jsHTMLSelectElementPrototypeFunctionBlur }, DontDelete|Function, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "add", { (intptr_t)jsHTMLSelectElementPrototypeFunctionAdd }, DontDelete|Function, 2, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "remove", { (intptr_t)jsHTMLSelectElementPrototypeFunctionRemove }, DontDelete|Function, 0, 0 },
    { "namedItem", { (intptr_t)jsHTMLSelectElementPrototypeFunctionNamedItem }, DontDelete|Function, 1, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "focus", { (intptr_t)jsHTMLSelectElementPrototypeFunctionFocus }, DontDelete|Function, 0, 0 },
    { "item", { (intptr_t)jsHTMLSelectElementPrototypeFunctionItem }, DontDelete|Function, 1, 0 }
};

static const HashTable JSHTMLSelectElementPrototypeTable = 
{
    3, 16, JSHTMLSelectElementPrototypeTableEntries, 15
};

const ClassInfo JSHTMLSelectElementPrototype::info = { "HTMLSelectElementPrototype", 0, &JSHTMLSelectElementPrototypeTable };

JSObject* JSHTMLSelectElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLSelectElementPrototype>(exec, "[[JSHTMLSelectElement.prototype]]");
}

bool JSHTMLSelectElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLSelectElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSHTMLSelectElement::info = { "HTMLSelectElement", &JSHTMLElement::info, &JSHTMLSelectElementTable };

JSHTMLSelectElement::JSHTMLSelectElement(JSObject* prototype, HTMLSelectElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLSelectElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    const HashEntry* entry = Lookup::findEntry(&JSHTMLSelectElementTable, propertyName);
    if (entry) {
        slot.setStaticEntry(this, entry, staticValueGetter<JSHTMLSelectElement>);
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<HTMLSelectElement*>(impl())->length()) {
        slot.setCustomIndex(this, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSHTMLSelectElement, Base>(exec, &JSHTMLSelectElementTable, this, propertyName, slot);
}

bool JSHTMLSelectElement::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    if (propertyName < static_cast<HTMLSelectElement*>(impl())->length()) {
        slot.setCustomIndex(this, propertyName, indexGetter);
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(propertyName), slot);
}

JSValue* JSHTMLSelectElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case TypeAttrNum: {
        HTMLSelectElement* imp = static_cast<HTMLSelectElement*>(impl());
        return jsString(imp->type());
    }
    case SelectedIndexAttrNum: {
        HTMLSelectElement* imp = static_cast<HTMLSelectElement*>(impl());
        return jsNumber(imp->selectedIndex());
    }
    case ValueAttrNum: {
        HTMLSelectElement* imp = static_cast<HTMLSelectElement*>(impl());
        return jsString(imp->value());
    }
    case LengthAttrNum: {
        HTMLSelectElement* imp = static_cast<HTMLSelectElement*>(impl());
        return jsNumber(imp->length());
    }
    case FormAttrNum: {
        HTMLSelectElement* imp = static_cast<HTMLSelectElement*>(impl());
        return toJS(exec, WTF::getPtr(imp->form()));
    }
    case OptionsAttrNum: {
        HTMLSelectElement* imp = static_cast<HTMLSelectElement*>(impl());
        return toJS(exec, WTF::getPtr(imp->options()));
    }
    case DisabledAttrNum: {
        HTMLSelectElement* imp = static_cast<HTMLSelectElement*>(impl());
        return jsBoolean(imp->disabled());
    }
    case MultipleAttrNum: {
        HTMLSelectElement* imp = static_cast<HTMLSelectElement*>(impl());
        return jsBoolean(imp->multiple());
    }
    case NameAttrNum: {
        HTMLSelectElement* imp = static_cast<HTMLSelectElement*>(impl());
        return jsString(imp->name());
    }
    case SizeAttrNum: {
        HTMLSelectElement* imp = static_cast<HTMLSelectElement*>(impl());
        return jsNumber(imp->size());
    }
    case TabIndexAttrNum: {
        HTMLSelectElement* imp = static_cast<HTMLSelectElement*>(impl());
        return jsNumber(imp->tabIndex());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLSelectElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok) {
        indexSetter(exec, index, value);
        return;
    }
    lookupPut<JSHTMLSelectElement, Base>(exec, propertyName, value, &JSHTMLSelectElementTable, this);
}

void JSHTMLSelectElement::put(ExecState* exec, unsigned propertyName, JSValue* value)
{
    indexSetter(exec, propertyName, value);
    return;
}

void JSHTMLSelectElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case SelectedIndexAttrNum: {
        HTMLSelectElement* imp = static_cast<HTMLSelectElement*>(impl());
        imp->setSelectedIndex(value->toInt32(exec));
        break;
    }
    case ValueAttrNum: {
        HTMLSelectElement* imp = static_cast<HTMLSelectElement*>(impl());
        imp->setValue(valueToStringWithNullCheck(exec, value));
        break;
    }
    case LengthAttrNum: {
        HTMLSelectElement* imp = static_cast<HTMLSelectElement*>(impl());
        ExceptionCode ec = 0;
        imp->setLength(value->toInt32(exec), ec);
        setDOMException(exec, ec);
        break;
    }
    case DisabledAttrNum: {
        HTMLSelectElement* imp = static_cast<HTMLSelectElement*>(impl());
        imp->setDisabled(value->toBoolean(exec));
        break;
    }
    case MultipleAttrNum: {
        HTMLSelectElement* imp = static_cast<HTMLSelectElement*>(impl());
        imp->setMultiple(value->toBoolean(exec));
        break;
    }
    case NameAttrNum: {
        HTMLSelectElement* imp = static_cast<HTMLSelectElement*>(impl());
        imp->setName(valueToStringWithNullCheck(exec, value));
        break;
    }
    case SizeAttrNum: {
        HTMLSelectElement* imp = static_cast<HTMLSelectElement*>(impl());
        imp->setSize(value->toInt32(exec));
        break;
    }
    case TabIndexAttrNum: {
        HTMLSelectElement* imp = static_cast<HTMLSelectElement*>(impl());
        imp->setTabIndex(value->toInt32(exec));
        break;
    }
    }
}

void JSHTMLSelectElement::getPropertyNames(ExecState* exec, PropertyNameArray& propertyNames)
{
    for (unsigned i = 0; i < static_cast<HTMLSelectElement*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(i));
     Base::getPropertyNames(exec, propertyNames);
}

JSValue* JSHTMLSelectElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLSelectElementConstructor>(exec, "[[HTMLSelectElement.constructor]]");
}

JSValue* jsHTMLSelectElementPrototypeFunctionAdd(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSHTMLSelectElement::info))
        return throwError(exec, TypeError);
    JSHTMLSelectElement* castedThisObj = static_cast<JSHTMLSelectElement*>(thisObj);
    HTMLSelectElement* imp = static_cast<HTMLSelectElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    HTMLElement* element = toHTMLElement(args[0]);
    HTMLElement* before = toHTMLElement(args[1]);

    imp->add(element, before, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue* jsHTMLSelectElementPrototypeFunctionRemove(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSHTMLSelectElement::info))
        return throwError(exec, TypeError);
    JSHTMLSelectElement* castedThisObj = static_cast<JSHTMLSelectElement*>(thisObj);
    return castedThisObj->remove(exec, args);
}

JSValue* jsHTMLSelectElementPrototypeFunctionBlur(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSHTMLSelectElement::info))
        return throwError(exec, TypeError);
    JSHTMLSelectElement* castedThisObj = static_cast<JSHTMLSelectElement*>(thisObj);
    HTMLSelectElement* imp = static_cast<HTMLSelectElement*>(castedThisObj->impl());

    imp->blur();
    return jsUndefined();
}

JSValue* jsHTMLSelectElementPrototypeFunctionFocus(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSHTMLSelectElement::info))
        return throwError(exec, TypeError);
    JSHTMLSelectElement* castedThisObj = static_cast<JSHTMLSelectElement*>(thisObj);
    HTMLSelectElement* imp = static_cast<HTMLSelectElement*>(castedThisObj->impl());

    imp->focus();
    return jsUndefined();
}

JSValue* jsHTMLSelectElementPrototypeFunctionItem(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSHTMLSelectElement::info))
        return throwError(exec, TypeError);
    JSHTMLSelectElement* castedThisObj = static_cast<JSHTMLSelectElement*>(thisObj);
    HTMLSelectElement* imp = static_cast<HTMLSelectElement*>(castedThisObj->impl());
    int index = args[0]->toInt32(exec);
    if (index < 0) {
        setDOMException(exec, INDEX_SIZE_ERR);
        return jsUndefined();
    }


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->item(index)));
    return result;
}

JSValue* jsHTMLSelectElementPrototypeFunctionNamedItem(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSHTMLSelectElement::info))
        return throwError(exec, TypeError);
    JSHTMLSelectElement* castedThisObj = static_cast<JSHTMLSelectElement*>(thisObj);
    HTMLSelectElement* imp = static_cast<HTMLSelectElement*>(castedThisObj->impl());
    String name = args[0]->toString(exec);


    KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->namedItem(name)));
    return result;
}


JSValue* JSHTMLSelectElement::indexGetter(ExecState* exec, JSObject* originalObject, const Identifier& propertyName, const PropertySlot& slot)
{
    JSHTMLSelectElement* thisObj = static_cast<JSHTMLSelectElement*>(slot.slotBase());
    return toJS(exec, static_cast<HTMLSelectElement*>(thisObj->impl())->item(slot.index()));
}

}
