/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLScriptElement.h"

#include <wtf/GetPtr.h>

#include "HTMLScriptElement.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLScriptElementTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "charset", { (intptr_t)JSHTMLScriptElement::CharsetAttrNum }, DontDelete, 0, 0 },
    { "src", { (intptr_t)JSHTMLScriptElement::SrcAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "event", { (intptr_t)JSHTMLScriptElement::EventAttrNum }, DontDelete, 0, 0 },
    { "htmlFor", { (intptr_t)JSHTMLScriptElement::HtmlForAttrNum }, DontDelete, 0, &JSHTMLScriptElementTableEntries[16] },
    { 0, { 0 }, 0, 0, 0 },
    { "type", { (intptr_t)JSHTMLScriptElement::TypeAttrNum }, DontDelete, 0, 0 },
    { "defer", { (intptr_t)JSHTMLScriptElement::DeferAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "text", { (intptr_t)JSHTMLScriptElement::TextAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "constructor", { (intptr_t)JSHTMLScriptElement::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSHTMLScriptElementTable = 
{
    3, 17, JSHTMLScriptElementTableEntries, 15
};

/* Hash table for constructor */

static const HashEntry JSHTMLScriptElementConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLScriptElementConstructorTable = 
{
    3, 1, JSHTMLScriptElementConstructorTableEntries, 0
};

class JSHTMLScriptElementConstructor : public DOMObject {
public:
    JSHTMLScriptElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLScriptElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLScriptElementConstructor::info = { "HTMLScriptElementConstructor", 0, &JSHTMLScriptElementConstructorTable };

bool JSHTMLScriptElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLScriptElementConstructor, DOMObject>(exec, &JSHTMLScriptElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLScriptElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLScriptElementPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLScriptElementPrototypeTable = 
{
    3, 1, JSHTMLScriptElementPrototypeTableEntries, 0
};

const ClassInfo JSHTMLScriptElementPrototype::info = { "HTMLScriptElementPrototype", 0, &JSHTMLScriptElementPrototypeTable };

JSObject* JSHTMLScriptElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLScriptElementPrototype>(exec, "[[JSHTMLScriptElement.prototype]]");
}

const ClassInfo JSHTMLScriptElement::info = { "HTMLScriptElement", &JSHTMLElement::info, &JSHTMLScriptElementTable };

JSHTMLScriptElement::JSHTMLScriptElement(JSObject* prototype, HTMLScriptElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLScriptElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLScriptElement, Base>(exec, &JSHTMLScriptElementTable, this, propertyName, slot);
}

JSValue* JSHTMLScriptElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case TextAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());
        return jsString(imp->text());
    }
    case HtmlForAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());
        return jsString(imp->htmlFor());
    }
    case EventAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());
        return jsString(imp->event());
    }
    case CharsetAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());
        return jsString(imp->charset());
    }
    case DeferAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());
        return jsBoolean(imp->defer());
    }
    case SrcAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());
        return jsString(imp->src());
    }
    case TypeAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());
        return jsString(imp->type());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLScriptElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLScriptElement, Base>(exec, propertyName, value, &JSHTMLScriptElementTable, this);
}

void JSHTMLScriptElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case TextAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());
        imp->setText(valueToStringWithNullCheck(exec, value));
        break;
    }
    case HtmlForAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());
        imp->setHtmlFor(valueToStringWithNullCheck(exec, value));
        break;
    }
    case EventAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());
        imp->setEvent(valueToStringWithNullCheck(exec, value));
        break;
    }
    case CharsetAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());
        imp->setCharset(valueToStringWithNullCheck(exec, value));
        break;
    }
    case DeferAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());
        imp->setDefer(value->toBoolean(exec));
        break;
    }
    case SrcAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());
        imp->setSrc(valueToStringWithNullCheck(exec, value));
        break;
    }
    case TypeAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());
        imp->setType(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLScriptElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLScriptElementConstructor>(exec, "[[HTMLScriptElement.constructor]]");
}


}
