/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLQuoteElement.h"

#include <wtf/GetPtr.h>

#include "HTMLQuoteElement.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLQuoteElementTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "cite", { (intptr_t)JSHTMLQuoteElement::CiteAttrNum }, DontDelete, 0, &JSHTMLQuoteElementTableEntries[4] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "constructor", { (intptr_t)JSHTMLQuoteElement::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSHTMLQuoteElementTable = 
{
    3, 5, JSHTMLQuoteElementTableEntries, 3
};

/* Hash table for constructor */

static const HashEntry JSHTMLQuoteElementConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLQuoteElementConstructorTable = 
{
    3, 1, JSHTMLQuoteElementConstructorTableEntries, 0
};

class JSHTMLQuoteElementConstructor : public DOMObject {
public:
    JSHTMLQuoteElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLQuoteElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLQuoteElementConstructor::info = { "HTMLQuoteElementConstructor", 0, &JSHTMLQuoteElementConstructorTable };

bool JSHTMLQuoteElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLQuoteElementConstructor, DOMObject>(exec, &JSHTMLQuoteElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLQuoteElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLQuoteElementPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLQuoteElementPrototypeTable = 
{
    3, 1, JSHTMLQuoteElementPrototypeTableEntries, 0
};

const ClassInfo JSHTMLQuoteElementPrototype::info = { "HTMLQuoteElementPrototype", 0, &JSHTMLQuoteElementPrototypeTable };

JSObject* JSHTMLQuoteElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLQuoteElementPrototype>(exec, "[[JSHTMLQuoteElement.prototype]]");
}

const ClassInfo JSHTMLQuoteElement::info = { "HTMLQuoteElement", &JSHTMLElement::info, &JSHTMLQuoteElementTable };

JSHTMLQuoteElement::JSHTMLQuoteElement(JSObject* prototype, HTMLQuoteElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLQuoteElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLQuoteElement, Base>(exec, &JSHTMLQuoteElementTable, this, propertyName, slot);
}

JSValue* JSHTMLQuoteElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case CiteAttrNum: {
        HTMLQuoteElement* imp = static_cast<HTMLQuoteElement*>(impl());
        return jsString(imp->cite());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLQuoteElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLQuoteElement, Base>(exec, propertyName, value, &JSHTMLQuoteElementTable, this);
}

void JSHTMLQuoteElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case CiteAttrNum: {
        HTMLQuoteElement* imp = static_cast<HTMLQuoteElement*>(impl());
        imp->setCite(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLQuoteElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLQuoteElementConstructor>(exec, "[[HTMLQuoteElement.constructor]]");
}


}
