/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLOptionsCollection.h"

#include <wtf/GetPtr.h>

#include "HTMLOptionsCollection.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLOptionsCollectionTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "length", { (intptr_t)JSHTMLOptionsCollection::LengthAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "selectedIndex", { (intptr_t)JSHTMLOptionsCollection::SelectedIndexAttrNum }, DontDelete, 0, 0 }
};

static const HashTable JSHTMLOptionsCollectionTable = 
{
    3, 4, JSHTMLOptionsCollectionTableEntries, 3
};

/* Hash table for prototype */

static const HashEntry JSHTMLOptionsCollectionPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "remove", { (intptr_t)jsHTMLOptionsCollectionPrototypeFunctionRemove }, DontDelete|Function, 1, 0 },
    { "add", { (intptr_t)jsHTMLOptionsCollectionPrototypeFunctionAdd }, DontDelete|Function, 2, 0 }
};

static const HashTable JSHTMLOptionsCollectionPrototypeTable = 
{
    3, 4, JSHTMLOptionsCollectionPrototypeTableEntries, 3
};

const ClassInfo JSHTMLOptionsCollectionPrototype::info = { "HTMLOptionsCollectionPrototype", 0, &JSHTMLOptionsCollectionPrototypeTable };

JSObject* JSHTMLOptionsCollectionPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLOptionsCollectionPrototype>(exec, "[[JSHTMLOptionsCollection.prototype]]");
}

bool JSHTMLOptionsCollectionPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLOptionsCollectionPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSHTMLOptionsCollection::info = { "HTMLOptionsCollection", &JSHTMLCollection::info, &JSHTMLOptionsCollectionTable };

JSHTMLOptionsCollection::JSHTMLOptionsCollection(JSObject* prototype, HTMLOptionsCollection* impl)
    : JSHTMLCollection(prototype, impl)
{
}

bool JSHTMLOptionsCollection::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLOptionsCollection, Base>(exec, &JSHTMLOptionsCollectionTable, this, propertyName, slot);
}

JSValue* JSHTMLOptionsCollection::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case SelectedIndexAttrNum: {
        HTMLOptionsCollection* imp = static_cast<HTMLOptionsCollection*>(impl());
        return jsNumber(imp->selectedIndex());
    }
    case LengthAttrNum: {
        return length(exec);
    }
    }
    return 0;
}

void JSHTMLOptionsCollection::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok) {
        indexSetter(exec, index, value);
        return;
    }
    lookupPut<JSHTMLOptionsCollection, Base>(exec, propertyName, value, &JSHTMLOptionsCollectionTable, this);
}

void JSHTMLOptionsCollection::put(ExecState* exec, unsigned propertyName, JSValue* value)
{
    indexSetter(exec, propertyName, value);
    return;
}

void JSHTMLOptionsCollection::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case SelectedIndexAttrNum: {
        HTMLOptionsCollection* imp = static_cast<HTMLOptionsCollection*>(impl());
        imp->setSelectedIndex(value->toInt32(exec));
        break;
    }
    case LengthAttrNum: {
        setLength(exec, value);
        break;
    }
    }
}

JSValue* jsHTMLOptionsCollectionPrototypeFunctionAdd(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSHTMLOptionsCollection::info))
        return throwError(exec, TypeError);
    JSHTMLOptionsCollection* castedThisObj = static_cast<JSHTMLOptionsCollection*>(thisObj);
    return castedThisObj->add(exec, args);
}

JSValue* jsHTMLOptionsCollectionPrototypeFunctionRemove(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSHTMLOptionsCollection::info))
        return throwError(exec, TypeError);
    JSHTMLOptionsCollection* castedThisObj = static_cast<JSHTMLOptionsCollection*>(thisObj);
    return castedThisObj->remove(exec, args);
}

HTMLOptionsCollection* toHTMLOptionsCollection(KJS::JSValue* val)
{
    return val->isObject(&JSHTMLOptionsCollection::info) ? static_cast<JSHTMLOptionsCollection*>(val)->impl() : 0;
}

HTMLOptionsCollection* JSHTMLOptionsCollection::impl() const
{
    return static_cast<HTMLOptionsCollection*>(Base::impl());
}

}
