/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLObjectElement.h"

#include <wtf/GetPtr.h>

#include "AtomicString.h"
#include "Document.h"
#include "HTMLFormElement.h"
#include "HTMLObjectElement.h"
#include "JSDocument.h"
#include "JSHTMLFormElement.h"
#include "KURL.h"
#include "kjs_binding.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLObjectElementTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "width", { (intptr_t)JSHTMLObjectElement::WidthAttrNum }, DontDelete, 0, 0 },
    { "vspace", { (intptr_t)JSHTMLObjectElement::VspaceAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "hspace", { (intptr_t)JSHTMLObjectElement::HspaceAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "form", { (intptr_t)JSHTMLObjectElement::FormAttrNum }, DontDelete|ReadOnly, 0, &JSHTMLObjectElementTableEntries[65] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "data", { (intptr_t)JSHTMLObjectElement::DataAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "name", { (intptr_t)JSHTMLObjectElement::NameAttrNum }, DontDelete, 0, &JSHTMLObjectElementTableEntries[66] },
    { "codeBase", { (intptr_t)JSHTMLObjectElement::CodeBaseAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "contentDocument", { (intptr_t)JSHTMLObjectElement::ContentDocumentAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "code", { (intptr_t)JSHTMLObjectElement::CodeAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "archive", { (intptr_t)JSHTMLObjectElement::ArchiveAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "height", { (intptr_t)JSHTMLObjectElement::HeightAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "codeType", { (intptr_t)JSHTMLObjectElement::CodeTypeAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "declare", { (intptr_t)JSHTMLObjectElement::DeclareAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "standby", { (intptr_t)JSHTMLObjectElement::StandbyAttrNum }, DontDelete, 0, 0 },
    { "border", { (intptr_t)JSHTMLObjectElement::BorderAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "type", { (intptr_t)JSHTMLObjectElement::TypeAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "align", { (intptr_t)JSHTMLObjectElement::AlignAttrNum }, DontDelete, 0, &JSHTMLObjectElementTableEntries[64] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "tabIndex", { (intptr_t)JSHTMLObjectElement::TabIndexAttrNum }, DontDelete, 0, 0 },
    { "useMap", { (intptr_t)JSHTMLObjectElement::UseMapAttrNum }, DontDelete, 0, 0 },
    { "constructor", { (intptr_t)JSHTMLObjectElement::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSHTMLObjectElementTable = 
{
    3, 67, JSHTMLObjectElementTableEntries, 63
};

/* Hash table for constructor */

static const HashEntry JSHTMLObjectElementConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLObjectElementConstructorTable = 
{
    3, 1, JSHTMLObjectElementConstructorTableEntries, 0
};

class JSHTMLObjectElementConstructor : public DOMObject {
public:
    JSHTMLObjectElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLObjectElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLObjectElementConstructor::info = { "HTMLObjectElementConstructor", 0, &JSHTMLObjectElementConstructorTable };

bool JSHTMLObjectElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLObjectElementConstructor, DOMObject>(exec, &JSHTMLObjectElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLObjectElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLObjectElementPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLObjectElementPrototypeTable = 
{
    3, 1, JSHTMLObjectElementPrototypeTableEntries, 0
};

const ClassInfo JSHTMLObjectElementPrototype::info = { "HTMLObjectElementPrototype", 0, &JSHTMLObjectElementPrototypeTable };

JSObject* JSHTMLObjectElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLObjectElementPrototype>(exec, "[[JSHTMLObjectElement.prototype]]");
}

const ClassInfo JSHTMLObjectElement::info = { "HTMLObjectElement", &JSHTMLElement::info, &JSHTMLObjectElementTable };

JSHTMLObjectElement::JSHTMLObjectElement(JSObject* prototype, HTMLObjectElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLObjectElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    if (canGetItemsForName(exec, static_cast<HTMLObjectElement*>(impl()), propertyName)) {
        slot.setCustom(this, nameGetter);
        return true;
    }
    if (customGetOwnPropertySlot(exec, propertyName, slot))
        return true;
    return getStaticValueSlot<JSHTMLObjectElement, Base>(exec, &JSHTMLObjectElementTable, this, propertyName, slot);
}

JSValue* JSHTMLObjectElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case FormAttrNum: {
        HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(impl());
        return toJS(exec, WTF::getPtr(imp->form()));
    }
    case CodeAttrNum: {
        HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(impl());
        return jsString(imp->code());
    }
    case AlignAttrNum: {
        HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(impl());
        return jsString(imp->align());
    }
    case ArchiveAttrNum: {
        HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(impl());
        return jsString(imp->archive());
    }
    case BorderAttrNum: {
        HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(impl());
        return jsString(imp->border());
    }
    case CodeBaseAttrNum: {
        HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(impl());
        return jsString(imp->codeBase());
    }
    case CodeTypeAttrNum: {
        HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(impl());
        return jsString(imp->codeType());
    }
    case DataAttrNum: {
        HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(impl());
        return jsString(imp->data());
    }
    case DeclareAttrNum: {
        HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(impl());
        return jsBoolean(imp->declare());
    }
    case HeightAttrNum: {
        HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(impl());
        return jsString(imp->height());
    }
    case HspaceAttrNum: {
        HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(impl());
        return jsNumber(imp->hspace());
    }
    case NameAttrNum: {
        HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(impl());
        return jsString(imp->name());
    }
    case StandbyAttrNum: {
        HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(impl());
        return jsString(imp->standby());
    }
    case TabIndexAttrNum: {
        HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(impl());
        return jsNumber(imp->tabIndex());
    }
    case TypeAttrNum: {
        HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(impl());
        return jsString(imp->type());
    }
    case UseMapAttrNum: {
        HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(impl());
        return jsString(imp->useMap());
    }
    case VspaceAttrNum: {
        HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(impl());
        return jsNumber(imp->vspace());
    }
    case WidthAttrNum: {
        HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(impl());
        return jsString(imp->width());
    }
    case ContentDocumentAttrNum: {
        HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(impl());
        return checkNodeSecurity(exec, imp->contentDocument()) ? toJS(exec, WTF::getPtr(imp->contentDocument())) : jsUndefined();
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLObjectElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    if (customPut(exec, propertyName, value))
        return;
    lookupPut<JSHTMLObjectElement, Base>(exec, propertyName, value, &JSHTMLObjectElementTable, this);
}

void JSHTMLObjectElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case CodeAttrNum: {
        HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(impl());
        imp->setCode(valueToStringWithNullCheck(exec, value));
        break;
    }
    case AlignAttrNum: {
        HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(impl());
        imp->setAlign(valueToStringWithNullCheck(exec, value));
        break;
    }
    case ArchiveAttrNum: {
        HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(impl());
        imp->setArchive(valueToStringWithNullCheck(exec, value));
        break;
    }
    case BorderAttrNum: {
        HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(impl());
        imp->setBorder(valueToStringWithNullCheck(exec, value));
        break;
    }
    case CodeBaseAttrNum: {
        HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(impl());
        imp->setCodeBase(valueToStringWithNullCheck(exec, value));
        break;
    }
    case CodeTypeAttrNum: {
        HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(impl());
        imp->setCodeType(valueToStringWithNullCheck(exec, value));
        break;
    }
    case DataAttrNum: {
        HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(impl());
        imp->setData(valueToStringWithNullCheck(exec, value));
        break;
    }
    case DeclareAttrNum: {
        HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(impl());
        imp->setDeclare(value->toBoolean(exec));
        break;
    }
    case HeightAttrNum: {
        HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(impl());
        imp->setHeight(valueToStringWithNullCheck(exec, value));
        break;
    }
    case HspaceAttrNum: {
        HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(impl());
        imp->setHspace(value->toInt32(exec));
        break;
    }
    case NameAttrNum: {
        HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(impl());
        imp->setName(valueToStringWithNullCheck(exec, value));
        break;
    }
    case StandbyAttrNum: {
        HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(impl());
        imp->setStandby(valueToStringWithNullCheck(exec, value));
        break;
    }
    case TabIndexAttrNum: {
        HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(impl());
        imp->setTabIndex(value->toInt32(exec));
        break;
    }
    case TypeAttrNum: {
        HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(impl());
        imp->setType(valueToStringWithNullCheck(exec, value));
        break;
    }
    case UseMapAttrNum: {
        HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(impl());
        imp->setUseMap(valueToStringWithNullCheck(exec, value));
        break;
    }
    case VspaceAttrNum: {
        HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(impl());
        imp->setVspace(value->toInt32(exec));
        break;
    }
    case WidthAttrNum: {
        HTMLObjectElement* imp = static_cast<HTMLObjectElement*>(impl());
        imp->setWidth(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLObjectElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLObjectElementConstructor>(exec, "[[HTMLObjectElement.constructor]]");
}


}
