/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLModElement.h"

#include <wtf/GetPtr.h>

#include "HTMLModElement.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLModElementTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "cite", { (intptr_t)JSHTMLModElement::CiteAttrNum }, DontDelete, 0, &JSHTMLModElementTableEntries[8] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "dateTime", { (intptr_t)JSHTMLModElement::DateTimeAttrNum }, DontDelete, 0, &JSHTMLModElementTableEntries[9] },
    { "constructor", { (intptr_t)JSHTMLModElement::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSHTMLModElementTable = 
{
    3, 10, JSHTMLModElementTableEntries, 7
};

/* Hash table for constructor */

static const HashEntry JSHTMLModElementConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLModElementConstructorTable = 
{
    3, 1, JSHTMLModElementConstructorTableEntries, 0
};

class JSHTMLModElementConstructor : public DOMObject {
public:
    JSHTMLModElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLModElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLModElementConstructor::info = { "HTMLModElementConstructor", 0, &JSHTMLModElementConstructorTable };

bool JSHTMLModElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLModElementConstructor, DOMObject>(exec, &JSHTMLModElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLModElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLModElementPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLModElementPrototypeTable = 
{
    3, 1, JSHTMLModElementPrototypeTableEntries, 0
};

const ClassInfo JSHTMLModElementPrototype::info = { "HTMLModElementPrototype", 0, &JSHTMLModElementPrototypeTable };

JSObject* JSHTMLModElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLModElementPrototype>(exec, "[[JSHTMLModElement.prototype]]");
}

const ClassInfo JSHTMLModElement::info = { "HTMLModElement", &JSHTMLElement::info, &JSHTMLModElementTable };

JSHTMLModElement::JSHTMLModElement(JSObject* prototype, HTMLModElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLModElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLModElement, Base>(exec, &JSHTMLModElementTable, this, propertyName, slot);
}

JSValue* JSHTMLModElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case CiteAttrNum: {
        HTMLModElement* imp = static_cast<HTMLModElement*>(impl());
        return jsString(imp->cite());
    }
    case DateTimeAttrNum: {
        HTMLModElement* imp = static_cast<HTMLModElement*>(impl());
        return jsString(imp->dateTime());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLModElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLModElement, Base>(exec, propertyName, value, &JSHTMLModElementTable, this);
}

void JSHTMLModElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case CiteAttrNum: {
        HTMLModElement* imp = static_cast<HTMLModElement*>(impl());
        imp->setCite(valueToStringWithNullCheck(exec, value));
        break;
    }
    case DateTimeAttrNum: {
        HTMLModElement* imp = static_cast<HTMLModElement*>(impl());
        imp->setDateTime(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLModElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLModElementConstructor>(exec, "[[HTMLModElement.constructor]]");
}


}
