/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLMetaElement.h"

#include <wtf/GetPtr.h>

#include "HTMLMetaElement.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLMetaElementTableEntries[] =
{
    { "httpEquiv", { (intptr_t)JSHTMLMetaElement::HttpEquivAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "name", { (intptr_t)JSHTMLMetaElement::NameAttrNum }, DontDelete, 0, &JSHTMLMetaElementTableEntries[16] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "content", { (intptr_t)JSHTMLMetaElement::ContentAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "scheme", { (intptr_t)JSHTMLMetaElement::SchemeAttrNum }, DontDelete, 0, 0 },
    { "constructor", { (intptr_t)JSHTMLMetaElement::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSHTMLMetaElementTable = 
{
    3, 17, JSHTMLMetaElementTableEntries, 15
};

/* Hash table for constructor */

static const HashEntry JSHTMLMetaElementConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLMetaElementConstructorTable = 
{
    3, 1, JSHTMLMetaElementConstructorTableEntries, 0
};

class JSHTMLMetaElementConstructor : public DOMObject {
public:
    JSHTMLMetaElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLMetaElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLMetaElementConstructor::info = { "HTMLMetaElementConstructor", 0, &JSHTMLMetaElementConstructorTable };

bool JSHTMLMetaElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLMetaElementConstructor, DOMObject>(exec, &JSHTMLMetaElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLMetaElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLMetaElementPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLMetaElementPrototypeTable = 
{
    3, 1, JSHTMLMetaElementPrototypeTableEntries, 0
};

const ClassInfo JSHTMLMetaElementPrototype::info = { "HTMLMetaElementPrototype", 0, &JSHTMLMetaElementPrototypeTable };

JSObject* JSHTMLMetaElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLMetaElementPrototype>(exec, "[[JSHTMLMetaElement.prototype]]");
}

const ClassInfo JSHTMLMetaElement::info = { "HTMLMetaElement", &JSHTMLElement::info, &JSHTMLMetaElementTable };

JSHTMLMetaElement::JSHTMLMetaElement(JSObject* prototype, HTMLMetaElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLMetaElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLMetaElement, Base>(exec, &JSHTMLMetaElementTable, this, propertyName, slot);
}

JSValue* JSHTMLMetaElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case ContentAttrNum: {
        HTMLMetaElement* imp = static_cast<HTMLMetaElement*>(impl());
        return jsString(imp->content());
    }
    case HttpEquivAttrNum: {
        HTMLMetaElement* imp = static_cast<HTMLMetaElement*>(impl());
        return jsString(imp->httpEquiv());
    }
    case NameAttrNum: {
        HTMLMetaElement* imp = static_cast<HTMLMetaElement*>(impl());
        return jsString(imp->name());
    }
    case SchemeAttrNum: {
        HTMLMetaElement* imp = static_cast<HTMLMetaElement*>(impl());
        return jsString(imp->scheme());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLMetaElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLMetaElement, Base>(exec, propertyName, value, &JSHTMLMetaElementTable, this);
}

void JSHTMLMetaElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case ContentAttrNum: {
        HTMLMetaElement* imp = static_cast<HTMLMetaElement*>(impl());
        imp->setContent(valueToStringWithNullCheck(exec, value));
        break;
    }
    case HttpEquivAttrNum: {
        HTMLMetaElement* imp = static_cast<HTMLMetaElement*>(impl());
        imp->setHttpEquiv(valueToStringWithNullCheck(exec, value));
        break;
    }
    case NameAttrNum: {
        HTMLMetaElement* imp = static_cast<HTMLMetaElement*>(impl());
        imp->setName(valueToStringWithNullCheck(exec, value));
        break;
    }
    case SchemeAttrNum: {
        HTMLMetaElement* imp = static_cast<HTMLMetaElement*>(impl());
        imp->setScheme(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLMetaElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLMetaElementConstructor>(exec, "[[HTMLMetaElement.constructor]]");
}


}
