/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLMarqueeElement.h"

#include <wtf/GetPtr.h>

#include "HTMLMarqueeElement.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLMarqueeElementTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "constructor", { (intptr_t)JSHTMLMarqueeElement::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSHTMLMarqueeElementTable = 
{
    3, 2, JSHTMLMarqueeElementTableEntries, 1
};

/* Hash table for constructor */

static const HashEntry JSHTMLMarqueeElementConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLMarqueeElementConstructorTable = 
{
    3, 1, JSHTMLMarqueeElementConstructorTableEntries, 0
};

class JSHTMLMarqueeElementConstructor : public DOMObject {
public:
    JSHTMLMarqueeElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLMarqueeElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLMarqueeElementConstructor::info = { "HTMLMarqueeElementConstructor", 0, &JSHTMLMarqueeElementConstructorTable };

bool JSHTMLMarqueeElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLMarqueeElementConstructor, DOMObject>(exec, &JSHTMLMarqueeElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLMarqueeElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLMarqueeElementPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "start", { (intptr_t)jsHTMLMarqueeElementPrototypeFunctionStart }, DontDelete|Function, 0, &JSHTMLMarqueeElementPrototypeTableEntries[4] },
    { 0, { 0 }, 0, 0, 0 },
    { "stop", { (intptr_t)jsHTMLMarqueeElementPrototypeFunctionStop }, DontDelete|Function, 0, 0 }
};

static const HashTable JSHTMLMarqueeElementPrototypeTable = 
{
    3, 5, JSHTMLMarqueeElementPrototypeTableEntries, 3
};

const ClassInfo JSHTMLMarqueeElementPrototype::info = { "HTMLMarqueeElementPrototype", 0, &JSHTMLMarqueeElementPrototypeTable };

JSObject* JSHTMLMarqueeElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLMarqueeElementPrototype>(exec, "[[JSHTMLMarqueeElement.prototype]]");
}

bool JSHTMLMarqueeElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLMarqueeElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSHTMLMarqueeElement::info = { "HTMLMarqueeElement", &JSHTMLElement::info, &JSHTMLMarqueeElementTable };

JSHTMLMarqueeElement::JSHTMLMarqueeElement(JSObject* prototype, HTMLMarqueeElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLMarqueeElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLMarqueeElement, Base>(exec, &JSHTMLMarqueeElementTable, this, propertyName, slot);
}

JSValue* JSHTMLMarqueeElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSHTMLMarqueeElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLMarqueeElementConstructor>(exec, "[[HTMLMarqueeElement.constructor]]");
}

JSValue* jsHTMLMarqueeElementPrototypeFunctionStart(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSHTMLMarqueeElement::info))
        return throwError(exec, TypeError);
    JSHTMLMarqueeElement* castedThisObj = static_cast<JSHTMLMarqueeElement*>(thisObj);
    HTMLMarqueeElement* imp = static_cast<HTMLMarqueeElement*>(castedThisObj->impl());

    imp->start();
    return jsUndefined();
}

JSValue* jsHTMLMarqueeElementPrototypeFunctionStop(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSHTMLMarqueeElement::info))
        return throwError(exec, TypeError);
    JSHTMLMarqueeElement* castedThisObj = static_cast<JSHTMLMarqueeElement*>(thisObj);
    HTMLMarqueeElement* imp = static_cast<HTMLMarqueeElement*>(castedThisObj->impl());

    imp->stop();
    return jsUndefined();
}


}
