/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLLabelElement.h"

#include <wtf/GetPtr.h>

#include "HTMLFormElement.h"
#include "HTMLLabelElement.h"
#include "JSHTMLFormElement.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLLabelElementTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "htmlFor", { (intptr_t)JSHTMLLabelElement::HtmlForAttrNum }, DontDelete, 0, &JSHTMLLabelElementTableEntries[8] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "form", { (intptr_t)JSHTMLLabelElement::FormAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "accessKey", { (intptr_t)JSHTMLLabelElement::AccessKeyAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "constructor", { (intptr_t)JSHTMLLabelElement::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSHTMLLabelElementTable = 
{
    3, 9, JSHTMLLabelElementTableEntries, 7
};

/* Hash table for constructor */

static const HashEntry JSHTMLLabelElementConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLLabelElementConstructorTable = 
{
    3, 1, JSHTMLLabelElementConstructorTableEntries, 0
};

class JSHTMLLabelElementConstructor : public DOMObject {
public:
    JSHTMLLabelElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLLabelElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLLabelElementConstructor::info = { "HTMLLabelElementConstructor", 0, &JSHTMLLabelElementConstructorTable };

bool JSHTMLLabelElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLLabelElementConstructor, DOMObject>(exec, &JSHTMLLabelElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLLabelElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLLabelElementPrototypeTableEntries[] =
{
    { "focus", { (intptr_t)jsHTMLLabelElementPrototypeFunctionFocus }, DontDelete|Function, 0, 0 },
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLLabelElementPrototypeTable = 
{
    3, 2, JSHTMLLabelElementPrototypeTableEntries, 1
};

const ClassInfo JSHTMLLabelElementPrototype::info = { "HTMLLabelElementPrototype", 0, &JSHTMLLabelElementPrototypeTable };

JSObject* JSHTMLLabelElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLLabelElementPrototype>(exec, "[[JSHTMLLabelElement.prototype]]");
}

bool JSHTMLLabelElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLLabelElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSHTMLLabelElement::info = { "HTMLLabelElement", &JSHTMLElement::info, &JSHTMLLabelElementTable };

JSHTMLLabelElement::JSHTMLLabelElement(JSObject* prototype, HTMLLabelElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLLabelElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLLabelElement, Base>(exec, &JSHTMLLabelElementTable, this, propertyName, slot);
}

JSValue* JSHTMLLabelElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case FormAttrNum: {
        HTMLLabelElement* imp = static_cast<HTMLLabelElement*>(impl());
        return toJS(exec, WTF::getPtr(imp->form()));
    }
    case AccessKeyAttrNum: {
        HTMLLabelElement* imp = static_cast<HTMLLabelElement*>(impl());
        return jsString(imp->accessKey());
    }
    case HtmlForAttrNum: {
        HTMLLabelElement* imp = static_cast<HTMLLabelElement*>(impl());
        return jsString(imp->htmlFor());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLLabelElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLLabelElement, Base>(exec, propertyName, value, &JSHTMLLabelElementTable, this);
}

void JSHTMLLabelElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case AccessKeyAttrNum: {
        HTMLLabelElement* imp = static_cast<HTMLLabelElement*>(impl());
        imp->setAccessKey(valueToStringWithNullCheck(exec, value));
        break;
    }
    case HtmlForAttrNum: {
        HTMLLabelElement* imp = static_cast<HTMLLabelElement*>(impl());
        imp->setHtmlFor(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLLabelElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLLabelElementConstructor>(exec, "[[HTMLLabelElement.constructor]]");
}

JSValue* jsHTMLLabelElementPrototypeFunctionFocus(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSHTMLLabelElement::info))
        return throwError(exec, TypeError);
    JSHTMLLabelElement* castedThisObj = static_cast<JSHTMLLabelElement*>(thisObj);
    HTMLLabelElement* imp = static_cast<HTMLLabelElement*>(castedThisObj->impl());

    imp->focus();
    return jsUndefined();
}


}
