/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLImageElement.h"

#include <wtf/GetPtr.h>

#include "HTMLImageElement.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLImageElementTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "src", { (intptr_t)JSHTMLImageElement::SrcAttrNum }, DontDelete, 0, &JSHTMLImageElementTableEntries[64] },
    { "vspace", { (intptr_t)JSHTMLImageElement::VspaceAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "hspace", { (intptr_t)JSHTMLImageElement::HspaceAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "y", { (intptr_t)JSHTMLImageElement::YAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "useMap", { (intptr_t)JSHTMLImageElement::UseMapAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "x", { (intptr_t)JSHTMLImageElement::XAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "complete", { (intptr_t)JSHTMLImageElement::CompleteAttrNum }, DontDelete|ReadOnly, 0, &JSHTMLImageElementTableEntries[65] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "name", { (intptr_t)JSHTMLImageElement::NameAttrNum }, DontDelete, 0, &JSHTMLImageElementTableEntries[66] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "isMap", { (intptr_t)JSHTMLImageElement::IsMapAttrNum }, DontDelete, 0, 0 },
    { "longDesc", { (intptr_t)JSHTMLImageElement::LongDescAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "height", { (intptr_t)JSHTMLImageElement::HeightAttrNum }, DontDelete, 0, 0 },
    { "lowsrc", { (intptr_t)JSHTMLImageElement::LowsrcAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "naturalHeight", { (intptr_t)JSHTMLImageElement::NaturalHeightAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "border", { (intptr_t)JSHTMLImageElement::BorderAttrNum }, DontDelete, 0, 0 },
    { "alt", { (intptr_t)JSHTMLImageElement::AltAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "align", { (intptr_t)JSHTMLImageElement::AlignAttrNum }, DontDelete, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "width", { (intptr_t)JSHTMLImageElement::WidthAttrNum }, DontDelete, 0, 0 },
    { "naturalWidth", { (intptr_t)JSHTMLImageElement::NaturalWidthAttrNum }, DontDelete|ReadOnly, 0, 0 },
    { "constructor", { (intptr_t)JSHTMLImageElement::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSHTMLImageElementTable = 
{
    3, 67, JSHTMLImageElementTableEntries, 63
};

/* Hash table for constructor */

static const HashEntry JSHTMLImageElementConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLImageElementConstructorTable = 
{
    3, 1, JSHTMLImageElementConstructorTableEntries, 0
};

class JSHTMLImageElementConstructor : public DOMObject {
public:
    JSHTMLImageElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLImageElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLImageElementConstructor::info = { "HTMLImageElementConstructor", 0, &JSHTMLImageElementConstructorTable };

bool JSHTMLImageElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLImageElementConstructor, DOMObject>(exec, &JSHTMLImageElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLImageElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLImageElementPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLImageElementPrototypeTable = 
{
    3, 1, JSHTMLImageElementPrototypeTableEntries, 0
};

const ClassInfo JSHTMLImageElementPrototype::info = { "HTMLImageElementPrototype", 0, &JSHTMLImageElementPrototypeTable };

JSObject* JSHTMLImageElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLImageElementPrototype>(exec, "[[JSHTMLImageElement.prototype]]");
}

const ClassInfo JSHTMLImageElement::info = { "HTMLImageElement", &JSHTMLElement::info, &JSHTMLImageElementTable };

JSHTMLImageElement::JSHTMLImageElement(JSObject* prototype, HTMLImageElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLImageElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLImageElement, Base>(exec, &JSHTMLImageElementTable, this, propertyName, slot);
}

JSValue* JSHTMLImageElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case NameAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        return jsString(imp->name());
    }
    case AlignAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        return jsString(imp->align());
    }
    case AltAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        return jsString(imp->alt());
    }
    case BorderAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        return jsString(imp->border());
    }
    case HeightAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        return jsNumber(imp->height());
    }
    case HspaceAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        return jsNumber(imp->hspace());
    }
    case IsMapAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        return jsBoolean(imp->isMap());
    }
    case LongDescAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        return jsString(imp->longDesc());
    }
    case SrcAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        return jsString(imp->src());
    }
    case UseMapAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        return jsString(imp->useMap());
    }
    case VspaceAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        return jsNumber(imp->vspace());
    }
    case WidthAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        return jsNumber(imp->width());
    }
    case CompleteAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        return jsBoolean(imp->complete());
    }
    case LowsrcAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        return jsString(imp->lowsrc());
    }
    case NaturalHeightAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        return jsNumber(imp->naturalHeight());
    }
    case NaturalWidthAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        return jsNumber(imp->naturalWidth());
    }
    case XAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        return jsNumber(imp->x());
    }
    case YAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        return jsNumber(imp->y());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLImageElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLImageElement, Base>(exec, propertyName, value, &JSHTMLImageElementTable, this);
}

void JSHTMLImageElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case NameAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        imp->setName(valueToStringWithNullCheck(exec, value));
        break;
    }
    case AlignAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        imp->setAlign(valueToStringWithNullCheck(exec, value));
        break;
    }
    case AltAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        imp->setAlt(valueToStringWithNullCheck(exec, value));
        break;
    }
    case BorderAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        imp->setBorder(valueToStringWithNullCheck(exec, value));
        break;
    }
    case HeightAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        imp->setHeight(value->toInt32(exec));
        break;
    }
    case HspaceAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        imp->setHspace(value->toInt32(exec));
        break;
    }
    case IsMapAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        imp->setIsMap(value->toBoolean(exec));
        break;
    }
    case LongDescAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        imp->setLongDesc(valueToStringWithNullCheck(exec, value));
        break;
    }
    case SrcAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        imp->setSrc(valueToStringWithNullCheck(exec, value));
        break;
    }
    case UseMapAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        imp->setUseMap(valueToStringWithNullCheck(exec, value));
        break;
    }
    case VspaceAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        imp->setVspace(value->toInt32(exec));
        break;
    }
    case WidthAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        imp->setWidth(value->toInt32(exec));
        break;
    }
    case LowsrcAttrNum: {
        HTMLImageElement* imp = static_cast<HTMLImageElement*>(impl());
        imp->setLowsrc(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLImageElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLImageElementConstructor>(exec, "[[HTMLImageElement.constructor]]");
}


}
