/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLHtmlElement.h"

#include <wtf/GetPtr.h>

#include "HTMLHtmlElement.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLHtmlElementTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "constructor", { (intptr_t)JSHTMLHtmlElement::ConstructorAttrNum }, DontEnum, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "version", { (intptr_t)JSHTMLHtmlElement::VersionAttrNum }, DontDelete, 0, 0 }
};

static const HashTable JSHTMLHtmlElementTable = 
{
    3, 4, JSHTMLHtmlElementTableEntries, 3
};

/* Hash table for constructor */

static const HashEntry JSHTMLHtmlElementConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLHtmlElementConstructorTable = 
{
    3, 1, JSHTMLHtmlElementConstructorTableEntries, 0
};

class JSHTMLHtmlElementConstructor : public DOMObject {
public:
    JSHTMLHtmlElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLHtmlElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLHtmlElementConstructor::info = { "HTMLHtmlElementConstructor", 0, &JSHTMLHtmlElementConstructorTable };

bool JSHTMLHtmlElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLHtmlElementConstructor, DOMObject>(exec, &JSHTMLHtmlElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLHtmlElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLHtmlElementPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLHtmlElementPrototypeTable = 
{
    3, 1, JSHTMLHtmlElementPrototypeTableEntries, 0
};

const ClassInfo JSHTMLHtmlElementPrototype::info = { "HTMLHtmlElementPrototype", 0, &JSHTMLHtmlElementPrototypeTable };

JSObject* JSHTMLHtmlElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLHtmlElementPrototype>(exec, "[[JSHTMLHtmlElement.prototype]]");
}

const ClassInfo JSHTMLHtmlElement::info = { "HTMLHtmlElement", &JSHTMLElement::info, &JSHTMLHtmlElementTable };

JSHTMLHtmlElement::JSHTMLHtmlElement(JSObject* prototype, HTMLHtmlElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLHtmlElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLHtmlElement, Base>(exec, &JSHTMLHtmlElementTable, this, propertyName, slot);
}

JSValue* JSHTMLHtmlElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case VersionAttrNum: {
        HTMLHtmlElement* imp = static_cast<HTMLHtmlElement*>(impl());
        return jsString(imp->version());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLHtmlElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLHtmlElement, Base>(exec, propertyName, value, &JSHTMLHtmlElementTable, this);
}

void JSHTMLHtmlElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case VersionAttrNum: {
        HTMLHtmlElement* imp = static_cast<HTMLHtmlElement*>(impl());
        imp->setVersion(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLHtmlElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLHtmlElementConstructor>(exec, "[[HTMLHtmlElement.constructor]]");
}


}
