/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLHeadingElement.h"

#include <wtf/GetPtr.h>

#include "HTMLHeadingElement.h"
#include "KURL.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLHeadingElementTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 },
    { "align", { (intptr_t)JSHTMLHeadingElement::AlignAttrNum }, DontDelete, 0, &JSHTMLHeadingElementTableEntries[4] },
    { 0, { 0 }, 0, 0, 0 },
    { 0, { 0 }, 0, 0, 0 },
    { "constructor", { (intptr_t)JSHTMLHeadingElement::ConstructorAttrNum }, DontEnum, 0, 0 }
};

static const HashTable JSHTMLHeadingElementTable = 
{
    3, 5, JSHTMLHeadingElementTableEntries, 3
};

/* Hash table for constructor */

static const HashEntry JSHTMLHeadingElementConstructorTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLHeadingElementConstructorTable = 
{
    3, 1, JSHTMLHeadingElementConstructorTableEntries, 0
};

class JSHTMLHeadingElementConstructor : public DOMObject {
public:
    JSHTMLHeadingElementConstructor(ExecState* exec)
        : DOMObject(exec->lexicalGlobalObject()->objectPrototype())
    {
        putDirect(exec->propertyNames().prototype, JSHTMLHeadingElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLHeadingElementConstructor::info = { "HTMLHeadingElementConstructor", 0, &JSHTMLHeadingElementConstructorTable };

bool JSHTMLHeadingElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLHeadingElementConstructor, DOMObject>(exec, &JSHTMLHeadingElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLHeadingElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLHeadingElementPrototypeTableEntries[] =
{
    { 0, { 0 }, 0, 0, 0 }
};

static const HashTable JSHTMLHeadingElementPrototypeTable = 
{
    3, 1, JSHTMLHeadingElementPrototypeTableEntries, 0
};

const ClassInfo JSHTMLHeadingElementPrototype::info = { "HTMLHeadingElementPrototype", 0, &JSHTMLHeadingElementPrototypeTable };

JSObject* JSHTMLHeadingElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLHeadingElementPrototype>(exec, "[[JSHTMLHeadingElement.prototype]]");
}

const ClassInfo JSHTMLHeadingElement::info = { "HTMLHeadingElement", &JSHTMLElement::info, &JSHTMLHeadingElementTable };

JSHTMLHeadingElement::JSHTMLHeadingElement(JSObject* prototype, HTMLHeadingElement* impl)
    : JSHTMLElement(prototype, impl)
{
}

bool JSHTMLHeadingElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLHeadingElement, Base>(exec, &JSHTMLHeadingElementTable, this, propertyName, slot);
}

JSValue* JSHTMLHeadingElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case AlignAttrNum: {
        HTMLHeadingElement* imp = static_cast<HTMLHeadingElement*>(impl());
        return jsString(imp->align());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLHeadingElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value)
{
    lookupPut<JSHTMLHeadingElement, Base>(exec, propertyName, value, &JSHTMLHeadingElementTable, this);
}

void JSHTMLHeadingElement::putValueProperty(ExecState* exec, int token, JSValue* value)
{
    switch (token) {
    case AlignAttrNum: {
        HTMLHeadingElement* imp = static_cast<HTMLHeadingElement*>(impl());
        imp->setAlign(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLHeadingElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLHeadingElementConstructor>(exec, "[[HTMLHeadingElement.constructor]]");
}


}
